/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.http;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.propagation.CurrentTraceContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.brave.BravePropagationContext;
import io.micronaut.tracing.opentracing.instrument.http.OpenTracingClientFilter;
import io.micronaut.tracing.opentracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.opentracing.instrument.http.TracingExclusionsConfiguration;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@Filter(value={"${tracing.http.client.path:/**}"})
@Requires(beans={HttpClientHandler.class})
@Replaces(value=OpenTracingClientFilter.class)
public final class BraveTracingClientFilter
implements HttpClientFilter {
    private final CurrentTraceContext currentTraceContext;
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler;
    @Nullable
    private final Predicate<String> pathExclusionTest;

    public BraveTracingClientFilter(CurrentTraceContext currentTraceContext, HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler, @Nullable TracingExclusionsConfiguration exclusionsConfiguration) {
        this.currentTraceContext = currentTraceContext;
        this.clientHandler = clientHandler;
        this.pathExclusionTest = exclusionsConfiguration == null ? null : exclusionsConfiguration.exclusionTest();
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        if (this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        HttpClientRequest httpClientRequest = this.mapRequest(request);
        Span span = this.clientHandler.handleSend(httpClientRequest);
        request.getAttribute((CharSequence)HttpAttributes.SERVICE_ID, String.class).filter(StringUtils::isNotEmpty).ifPresent(arg_0 -> ((Span)span).remoteServiceName(arg_0));
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new BravePropagationContext(this.currentTraceContext, span.context())).propagate();){
            Mono mono = Mono.from((Publisher)chain.proceed(request)).doOnNext(response -> this.clientHandler.handleReceive(this.mapResponse((HttpRequest<?>)request, (HttpResponse<?>)response, null), span)).doOnError(throwable -> {
                if (throwable instanceof HttpClientResponseException) {
                    HttpClientResponseException e = (HttpClientResponseException)throwable;
                    this.clientHandler.handleReceive(this.mapResponse((HttpRequest<?>)request, (HttpResponse<?>)e.getResponse(), (Throwable)e), span);
                } else {
                    span.error(throwable);
                }
            });
            return mono;
        }
    }

    private boolean shouldExclude(@Nullable String path) {
        return this.pathExclusionTest != null && path != null && this.pathExclusionTest.test(path);
    }

    private HttpClientRequest mapRequest(final MutableHttpRequest<?> request) {
        return new HttpClientRequest(){

            public void header(String name, String value) {
                request.header((CharSequence)name, (CharSequence)value);
            }

            public String method() {
                return request.getMethodName();
            }

            public String path() {
                return request.getPath();
            }

            public String url() {
                return request.getUri().toString();
            }

            public String header(String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Object unwrap() {
                return request;
            }
        };
    }

    private HttpClientResponse mapResponse(final HttpRequest<?> request, final HttpResponse<?> response, final Throwable error) {
        return new HttpClientResponse(){

            public Object unwrap() {
                return response;
            }

            public Throwable error() {
                return error;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return response.getStatus().getCode();
            }
        };
    }
}

