/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.http;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.propagation.CurrentTraceContext;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.tracing.brave.BravePropagationContext;
import io.micronaut.tracing.opentracing.instrument.http.OpenTracingServerFilter;
import io.micronaut.tracing.opentracing.instrument.http.TracingExclusionsConfiguration;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@Internal
@Filter(value={"${tracing.http.server.path:/**}"})
@Requires(beans={HttpServerHandler.class})
@Replaces(value=OpenTracingServerFilter.class)
public final class BraveTracingServerFilter
implements HttpServerFilter {
    private final CurrentTraceContext currentTraceContext;
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler;
    @Nullable
    private final Predicate<String> pathExclusionTest;

    @Inject
    public BraveTracingServerFilter(CurrentTraceContext currentTraceContext, HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler, @Nullable TracingExclusionsConfiguration exclusionsConfiguration) {
        this.currentTraceContext = currentTraceContext;
        this.serverHandler = serverHandler;
        this.pathExclusionTest = exclusionsConfiguration == null ? null : exclusionsConfiguration.exclusionTest();
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        if (this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        HttpServerRequest httpServerRequest = this.mapRequest(request);
        Span span = this.serverHandler.handleReceive(httpServerRequest);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new BravePropagationContext(this.currentTraceContext, span.context())).propagate();){
            PropagatedContext propagatedContext = PropagatedContext.get();
            Mono mono = Mono.from((Publisher)chain.proceed(request)).doOnNext(response -> {
                Optional throwable = response.getAttribute((CharSequence)HttpAttributes.EXCEPTION, Throwable.class);
                if (throwable.isPresent()) {
                    int statusCode = 500;
                    Throwable error = (Throwable)throwable.get();
                    if (error instanceof HttpStatusException) {
                        statusCode = ((HttpStatusException)error).getStatus().getCode();
                    }
                    this.serverHandler.handleSend(this.mapResponse(request, statusCode, error), span);
                } else {
                    this.serverHandler.handleSend(this.mapResponse(request, (HttpResponse<?>)response), span);
                }
            }).doOnError(throwable -> span.error(throwable).finish()).contextWrite(ctx -> ReactorPropagation.addPropagatedContext((Context)ctx, (PropagatedContext)propagatedContext));
            return mono;
        }
    }

    public int getOrder() {
        return ServerFilterPhase.TRACING.order();
    }

    private boolean shouldExclude(@Nullable String path) {
        return this.pathExclusionTest != null && path != null && this.pathExclusionTest.test(path);
    }

    private HttpServerRequest mapRequest(final HttpRequest<?> request) {
        return new HttpServerRequest(){

            public String method() {
                return request.getMethodName();
            }

            public String path() {
                return request.getPath();
            }

            public String url() {
                return request.getUri().toString();
            }

            public String header(String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Object unwrap() {
                return request;
            }
        };
    }

    private HttpServerResponse mapResponse(final HttpRequest<?> request, final HttpResponse<?> response) {
        return new HttpServerResponse(){

            public Object unwrap() {
                return response;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return response.getStatus().getCode();
            }
        };
    }

    private HttpServerResponse mapResponse(final HttpRequest<?> request, final int statusCode, final Throwable error) {
        return new HttpServerResponse(){

            public Throwable error() {
                return error;
            }

            public Object unwrap() {
                return this;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return statusCode;
            }
        };
    }
}

