/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave;

import brave.Clock;
import brave.ErrorParser;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.sampler.CountingSampler;
import brave.sampler.Sampler;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.tracing.brave.sender.HttpClientSender;
import jakarta.inject.Inject;

@Requirements(value={@Requires(classes={Tracing.class}), @Requires(property="tracing.zipkin.enabled", value="true")})
@ConfigurationProperties(value="tracing.zipkin")
public class BraveTracerConfiguration
implements Toggleable {
    public static final String PREFIX = "tracing.zipkin";
    public static final float DEFAULT_SAMPLER_PROBABILITY = 0.1f;
    public static final boolean DEFAULT_ENABLED = false;
    @ConfigurationBuilder(prefixes={""}, excludes={"errorParser", "clock", "endpoint", "spanReporter", "propagationFactory", "currentTraceContext", "sampler"})
    protected Tracing.Builder tracingBuilder = Tracing.newBuilder();
    private boolean enabled = false;

    public BraveTracerConfiguration(ApplicationConfiguration configuration) {
        this.tracingBuilder.sampler(CountingSampler.create((float)0.1f));
        if (configuration != null) {
            this.tracingBuilder.localServiceName(configuration.getName().orElse("application"));
        } else {
            this.tracingBuilder.localServiceName("application");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Inject
    public void setSamplerConfiguration(@Nullable SamplerConfiguration samplerConfiguration) {
        if (samplerConfiguration != null) {
            this.tracingBuilder.sampler(CountingSampler.create((float)samplerConfiguration.getProbability()));
        }
    }

    public Tracing.Builder getTracingBuilder() {
        return this.tracingBuilder;
    }

    @Inject
    public void setSampler(@Nullable Sampler sampler) {
        if (sampler != null) {
            this.tracingBuilder.sampler(sampler);
        }
    }

    @Inject
    public void setErrorParser(@Nullable ErrorParser errorParser) {
        if (errorParser != null) {
            this.tracingBuilder.errorParser(errorParser);
        }
    }

    @Inject
    public void setPropagationFactory(@Nullable Propagation.Factory propagationFactory) {
        if (propagationFactory != null) {
            this.tracingBuilder.propagationFactory(propagationFactory);
        }
    }

    @Inject
    public void setClock(@Nullable Clock clock) {
        if (clock != null) {
            this.tracingBuilder.clock(clock);
        }
    }

    @Inject
    public void setCurrentTraceContext(CurrentTraceContext traceContext) {
        if (traceContext != null) {
            this.tracingBuilder.currentTraceContext(traceContext);
        }
    }

    @ConfigurationProperties(value="sampler")
    @Requirements(value={@Requires(classes={CountingSampler.class}), @Requires(missingBeans={Sampler.class})})
    public static class SamplerConfiguration {
        private float probability = 0.1f;

        public float getProbability() {
            return this.probability;
        }

        public void setProbability(float probability) {
            this.probability = probability;
        }
    }

    @ConfigurationProperties(value="http")
    @Requirements(value={@Requires(property="tracing.zipkin.http"), @Requires(classes={Tracing.class})})
    public static class HttpClientSenderConfiguration
    extends HttpClientConfiguration {
        public static final String PREFIX = "tracing.zipkin.http";
        @ConfigurationBuilder(prefixes={""})
        protected final HttpClientSender.Builder clientSenderBuilder = new HttpClientSender.Builder(this);

        public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
            return new HttpClientConfiguration.ConnectionPoolConfiguration();
        }

        public HttpClientSender.Builder getBuilder() {
            return this.clientSenderBuilder;
        }
    }
}

