/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.log;

import brave.internal.codec.HexCodec;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class Slf4jScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jScopeDecorator.class);
    private static final String LEGACY_EXPORTABLE_NAME = "X-Span-Export";
    private static final String LEGACY_PARENT_ID_NAME = "X-B3-ParentSpanId";
    private static final String LEGACY_TRACE_ID_NAME = "X-B3-TraceId";
    private static final String LEGACY_SPAN_ID_NAME = "X-B3-SpanId";

    Slf4jScopeDecorator() {
    }

    public CurrentTraceContext.Scope decorateScope(TraceContext currentSpan, CurrentTraceContext.Scope scope) {
        String previousTraceId = MDC.get((String)"traceId");
        String previousParentId = MDC.get((String)"parentId");
        String previousSpanId = MDC.get((String)"spanId");
        String spanExportable = MDC.get((String)"spanExportable");
        String legacyPreviousTraceId = MDC.get((String)LEGACY_TRACE_ID_NAME);
        String legacyPreviousParentId = MDC.get((String)LEGACY_PARENT_ID_NAME);
        String legacyPreviousSpanId = MDC.get((String)LEGACY_SPAN_ID_NAME);
        String legacySpanExportable = MDC.get((String)LEGACY_EXPORTABLE_NAME);
        if (currentSpan != null) {
            String traceIdString = currentSpan.traceIdString();
            MDC.put((String)"traceId", (String)traceIdString);
            MDC.put((String)LEGACY_TRACE_ID_NAME, (String)traceIdString);
            String parentId = currentSpan.parentId() == null ? null : HexCodec.toLowerHex((long)currentSpan.parentId());
            Slf4jScopeDecorator.replace("parentId", parentId);
            Slf4jScopeDecorator.replace(LEGACY_PARENT_ID_NAME, parentId);
            String spanId = HexCodec.toLowerHex((long)currentSpan.spanId());
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)LEGACY_SPAN_ID_NAME, (String)spanId);
            String sampled = String.valueOf(currentSpan.sampled());
            MDC.put((String)"spanExportable", (String)sampled);
            MDC.put((String)LEGACY_EXPORTABLE_NAME, (String)sampled);
            LOG.trace("Starting scope for span: {}", (Object)currentSpan);
            if (currentSpan.parentId() != null) {
                LOG.trace("With parent: {}", (Object)currentSpan.parentId());
            }
        } else {
            MDC.remove((String)"traceId");
            MDC.remove((String)"parentId");
            MDC.remove((String)"spanId");
            MDC.remove((String)"spanExportable");
            MDC.remove((String)LEGACY_TRACE_ID_NAME);
            MDC.remove((String)LEGACY_PARENT_ID_NAME);
            MDC.remove((String)LEGACY_SPAN_ID_NAME);
            MDC.remove((String)LEGACY_EXPORTABLE_NAME);
        }
        return () -> {
            if (currentSpan != null) {
                LOG.trace("Closing scope for span: {}", (Object)currentSpan);
            }
            scope.close();
            Slf4jScopeDecorator.replace("traceId", previousTraceId);
            Slf4jScopeDecorator.replace("parentId", previousParentId);
            Slf4jScopeDecorator.replace("spanId", previousSpanId);
            Slf4jScopeDecorator.replace("spanExportable", spanExportable);
            Slf4jScopeDecorator.replace(LEGACY_TRACE_ID_NAME, legacyPreviousTraceId);
            Slf4jScopeDecorator.replace(LEGACY_PARENT_ID_NAME, legacyPreviousParentId);
            Slf4jScopeDecorator.replace(LEGACY_SPAN_ID_NAME, legacyPreviousSpanId);
            Slf4jScopeDecorator.replace(LEGACY_EXPORTABLE_NAME, legacySpanExportable);
        };
    }

    private static void replace(String key, String value) {
        if (value == null) {
            MDC.remove((String)key);
        } else {
            MDC.put((String)key, (String)value);
        }
    }
}

