/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.tracing.brave.BraveTracerConfiguration;
import jakarta.inject.Inject;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@ConfigurationProperties(value="tracing.zipkin.reporter")
@Requirements(value={@Requires(beans={BraveTracerConfiguration.class}), @Requires(beans={Sender.class})})
public class AsyncReporterConfiguration {
    public static final String PREFIX = "tracing.zipkin.reporter";
    @ConfigurationBuilder(prefixes={""})
    private final AsyncReporter.Builder builder;

    public AsyncReporterConfiguration(BraveTracerConfiguration configuration, Sender sender) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument [configuration] cannot be null");
        }
        this.builder = AsyncReporter.builder((Sender)sender);
    }

    public AsyncReporter.Builder getBuilder() {
        return this.builder;
    }

    @Inject
    public void setReporterMetrics(@Nullable ReporterMetrics metrics) {
        if (metrics != null) {
            this.builder.metrics(metrics);
        }
    }
}

