/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.List;
import javax.annotation.Nullable;

@Internal
enum MicronautHttpClientAttributesGetter implements HttpClientAttributesGetter<MutableHttpRequest<Object>, HttpResponse<Object>>
{
    INSTANCE;


    public String method(MutableHttpRequest<Object> request) {
        return request.getMethodName();
    }

    public String url(MutableHttpRequest<Object> request) {
        return request.getUri().toString();
    }

    public List<String> requestHeader(MutableHttpRequest<Object> request, String name) {
        return request.getHeaders().getAll((CharSequence)name);
    }

    public Long requestContentLength(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return request.getContentLength();
    }

    @Nullable
    public Long requestContentLengthUncompressed(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return null;
    }

    @Nullable
    public String flavor(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        switch (request.getHttpVersion()) {
            case HTTP_1_0: {
                return "1.0";
            }
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2_0: {
                return "2.0";
            }
        }
        return null;
    }

    public Integer statusCode(MutableHttpRequest<Object> request, HttpResponse<Object> response) {
        return response.code();
    }

    public Long responseContentLength(MutableHttpRequest<Object> request, HttpResponse<Object> response) {
        return response.getContentLength();
    }

    @Nullable
    public Long responseContentLengthUncompressed(MutableHttpRequest<Object> request, HttpResponse<Object> response) {
        return null;
    }

    public List<String> responseHeader(MutableHttpRequest<Object> request, HttpResponse<Object> response, String name) {
        return response.getHeaders().getAll((CharSequence)name);
    }
}

