/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

@Internal
final class MicronautHttpNetClientAttributesGetter
implements NetClientAttributesGetter<MutableHttpRequest<Object>, HttpResponse<Object>> {
    MicronautHttpNetClientAttributesGetter() {
    }

    public InetSocketAddress getAddress(MutableHttpRequest<Object> request) {
        return request.getRemoteAddress();
    }

    public String transport(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return "ip_tcp";
    }

    public String peerName(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return request.getAttribute((CharSequence)HttpAttributes.SERVICE_ID, String.class).filter(serviceId -> !serviceId.contains("/")).orElseGet(() -> this.getAddress(request).getHostString());
    }

    public Integer peerPort(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return this.getAddress(request).getPort();
    }

    public String peerIp(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        InetSocketAddress address = this.getAddress(request);
        InetAddress remoteAddress = address.getAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }
}

