/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.client;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.annotation.ContinueSpan;
import io.micronaut.tracing.opentelemetry.instrument.http.AbstractOpenTelemetryFilter;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryExclusionsConfiguration;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryPublisherUtils;
import io.micronaut.tracing.opentelemetry.interceptor.AbstractOpenTelemetryTraceInterceptor;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.inject.Named;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.client.path:/**}"})
public class OpenTelemetryClientFilter
extends AbstractOpenTelemetryFilter
implements HttpClientFilter {
    private final Instrumenter<MutableHttpRequest<?>, Object> instrumenter;

    public OpenTelemetryClientFilter(@Nullable OpenTelemetryExclusionsConfiguration exclusionsConfig, @Named(value="micronautHttpClientTelemetryInstrumenter") Instrumenter<MutableHttpRequest<?>, Object> instrumenter) {
        super(exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
        this.instrumenter = instrumenter;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        Publisher requestPublisher = chain.proceed(request);
        if (this.shouldExclude(request.getPath())) {
            return requestPublisher;
        }
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return requestPublisher;
        }
        Context newContext = this.instrumenter.start(parentContext, request);
        try (Scope ignored = newContext.makeCurrent();){
            this.handleContinueSpan(request);
        }
        return OpenTelemetryPublisherUtils.createOpenTelemetryPublisher((Publisher)requestPublisher, this.instrumenter, (Context)newContext, request);
    }

    private void handleContinueSpan(MutableHttpRequest<?> request) {
        MethodInvocationContext context;
        Object invocationContext = request.getAttribute((CharSequence)HttpAttributes.INVOCATION_CONTEXT).orElse(null);
        if (invocationContext instanceof MethodInvocationContext && (context = (MethodInvocationContext)invocationContext).hasAnnotation(ContinueSpan.class)) {
            AbstractOpenTelemetryTraceInterceptor.tagArguments((MethodInvocationContext)context);
        }
    }
}

