/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.server;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@Internal
enum MicronautHttpServerAttributesGetter implements HttpServerAttributesGetter<HttpRequest<Object>, HttpResponse<Object>>
{
    INSTANCE;


    public String method(HttpRequest<Object> request) {
        return request.getMethodName();
    }

    public List<String> requestHeader(HttpRequest<Object> request, String name) {
        return request.getHeaders().getAll((CharSequence)name);
    }

    public Long requestContentLength(HttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return request.getContentLength();
    }

    @Nullable
    public Long requestContentLengthUncompressed(HttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return null;
    }

    public Integer statusCode(HttpRequest<Object> request, HttpResponse<Object> response) {
        return response.code();
    }

    @Nullable
    public Long responseContentLength(HttpRequest<Object> request, HttpResponse<Object> response) {
        return response.getContentLength();
    }

    @Nullable
    public Long responseContentLengthUncompressed(HttpRequest<Object> request, HttpResponse<Object> response) {
        return null;
    }

    public List<String> responseHeader(HttpRequest<Object> request, HttpResponse<Object> response, String name) {
        return response.getHeaders().getAll((CharSequence)name);
    }

    @Nullable
    public String flavor(HttpRequest<Object> request) {
        switch (request.getHttpVersion()) {
            case HTTP_1_0: {
                return "1.0";
            }
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2_0: {
                return "2.0";
            }
        }
        return null;
    }

    public String target(HttpRequest<Object> request) {
        String requestPath = request.getPath();
        String queryString = request.getUri().getRawQuery();
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            return requestPath + '?' + queryString;
        }
        return requestPath;
    }

    @Nullable
    public String route(HttpRequest<Object> request) {
        Optional routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO);
        return routeInfo.map(Object::toString).orElse(null);
    }

    public String scheme(HttpRequest<Object> request) {
        return request.getUri().getScheme();
    }

    @Nullable
    public String serverName(HttpRequest<Object> request) {
        return request.getServerName();
    }
}

