/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.server;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.tracing.opentelemetry.instrument.http.server.HttpRequestGetter;
import io.micronaut.tracing.opentelemetry.instrument.http.server.MicronautHttpNetServerAttributesGetter;
import io.micronaut.tracing.opentelemetry.instrument.http.server.MicronautHttpServerAttributesGetter;
import io.micronaut.tracing.opentelemetry.instrument.http.server.OpenTelemetryHttpServerConfig;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@Factory
public final class MicronautHttpServerTelemetryFactory {
    private static final String INSTRUMENTATION_NAME = "io.micronaut.http.server";

    @Prototype
    @Requires(beans={OpenTelemetry.class})
    @Named(value="micronautHttpServerTelemetryInstrumenter")
    public Instrumenter<HttpRequest<Object>, HttpResponse<Object>> instrumenter(OpenTelemetry openTelemetry, @Server List<AttributesExtractor<HttpRequest<?>, HttpResponse<?>>> extractors) {
        MicronautHttpServerAttributesGetter httpAttributesGetter = MicronautHttpServerAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter));
        builder.addAttributesExtractors(extractors);
        return builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpServerMetrics.get()).addContextCustomizer(HttpRouteHolder.get()).newServerInstrumenter((TextMapGetter)HttpRequestGetter.INSTANCE);
    }

    @Prototype
    @Server
    HttpServerAttributesExtractor<HttpRequest<Object>, HttpResponse<Object>> httpServerAttributesExtractor(@Nullable OpenTelemetryHttpServerConfig openTelemetryHttpServerConfig) {
        HttpServerAttributesExtractorBuilder httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)MicronautHttpServerAttributesGetter.INSTANCE);
        if (openTelemetryHttpServerConfig != null) {
            httpAttributesExtractorBuilder.setCapturedRequestHeaders(openTelemetryHttpServerConfig.getRequestHeaders());
            httpAttributesExtractorBuilder.setCapturedResponseHeaders(openTelemetryHttpServerConfig.getResponseHeaders());
        }
        return httpAttributesExtractorBuilder.build();
    }

    @Prototype
    @Server
    NetServerAttributesExtractor<HttpRequest<Object>, HttpResponse<Object>> netServerAttributesExtractor() {
        return NetServerAttributesExtractor.create((NetServerAttributesGetter)new MicronautHttpNetServerAttributesGetter());
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Server {
    }
}

