/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.tracing.opentelemetry.instrument.http.AbstractOpenTelemetryFilter;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryExclusionsConfiguration;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryObserver;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryPublisherUtils;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.inject.Named;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.server.path:/**}"})
@Requires(beans={Tracer.class})
public class OpenTelemetryServerFilter
extends AbstractOpenTelemetryFilter
implements HttpServerFilter {
    private static final String APPLIED = OpenTelemetryServerFilter.class.getName() + "-applied";
    private static final String CONTINUE = OpenTelemetryServerFilter.class.getName() + "-continue";
    private final Instrumenter<HttpRequest<?>, Object> instrumenter;

    public OpenTelemetryServerFilter(@Nullable OpenTelemetryExclusionsConfiguration exclusionsConfig, @Named(value="micronautHttpServerTelemetryInstrumenter") Instrumenter<HttpRequest<?>, Object> instrumenter) {
        super(exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
        this.instrumenter = instrumenter;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(final HttpRequest<?> request, ServerFilterChain chain) {
        boolean applied = request.getAttribute((CharSequence)APPLIED, Boolean.class).orElse(false);
        boolean continued = request.getAttribute((CharSequence)CONTINUE, Boolean.class).orElse(false);
        Publisher requestPublisher = chain.proceed(request);
        if (applied && !continued || this.shouldExclude(request.getPath())) {
            return requestPublisher;
        }
        request.setAttribute((CharSequence)APPLIED, (Object)true);
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return requestPublisher;
        }
        Context newContext = this.instrumenter.start(parentContext, request);
        return OpenTelemetryPublisherUtils.createOpenTelemetryPublisher((Publisher)requestPublisher, this.instrumenter, (Context)newContext, request, (OpenTelemetryObserver)new OpenTelemetryObserver<MutableHttpResponse<?>>(){

            public void doOnError(@NonNull Throwable throwable, @NonNull Context openTelemetryContext) {
                request.setAttribute((CharSequence)CONTINUE, (Object)true);
                OpenTelemetryPublisherUtils.logError((Context)openTelemetryContext, (Throwable)throwable);
            }
        });
    }
}

