/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.client;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MutableHttpRequest;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.List;
import java.util.Map;

@Internal
enum MicronautHttpClientAttributesGetter implements HttpClientAttributesGetter<MutableHttpRequest<Object>, HttpResponse<Object>>
{
    INSTANCE;

    private static final Map<HttpVersion, String> PROTOCOL_VERSION;

    public String getHttpRequestMethod(MutableHttpRequest<Object> request) {
        return request.getMethodName();
    }

    public List<String> getHttpRequestHeader(MutableHttpRequest<Object> request, String name) {
        return request.getHeaders().getAll((CharSequence)name);
    }

    public Integer getHttpResponseStatusCode(MutableHttpRequest<Object> request, HttpResponse<Object> response, @Nullable Throwable error) {
        return response.code();
    }

    public List<String> getHttpResponseHeader(MutableHttpRequest<Object> request, HttpResponse<Object> response, String name) {
        return response.getHeaders().getAll((CharSequence)name);
    }

    public String getUrlFull(MutableHttpRequest<Object> request) {
        return request.getUri().toString();
    }

    @Nullable
    public String getNetworkProtocolVersion(MutableHttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return PROTOCOL_VERSION.get(request.getHttpVersion());
    }

    @Nullable
    public String getServerAddress(MutableHttpRequest<Object> request) {
        return request.getAttribute((CharSequence)HttpAttributes.SERVICE_ID, String.class).filter(serviceId -> !serviceId.contains("/")).orElseGet(() -> request.getRemoteAddress().getHostString());
    }

    @Nullable
    public Integer getServerPort(MutableHttpRequest<Object> request) {
        return request.getServerAddress().getPort();
    }

    static {
        PROTOCOL_VERSION = Map.of(HttpVersion.HTTP_1_0, "1.0", HttpVersion.HTTP_1_1, "1.1", HttpVersion.HTTP_2_0, "2.0");
    }
}

