/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.client;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.tracing.opentelemetry.instrument.http.client.HttpRequestSetter;
import io.micronaut.tracing.opentelemetry.instrument.http.client.MicronautHttpClientAttributesGetter;
import io.micronaut.tracing.opentelemetry.instrument.http.client.OpenTelemetryHttpClientConfig;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;

@Factory
public class MicronautHttpClientTelemetryFactory {
    private static final String INSTRUMENTATION_NAME = "io.micronaut.http.client";

    @Prototype
    @Requires(beans={OpenTelemetry.class})
    @Named(value="micronautHttpClientTelemetryInstrumenter")
    Instrumenter<MutableHttpRequest<Object>, HttpResponse<Object>> instrumenter(OpenTelemetry openTelemetry, @Client List<AttributesExtractor<MutableHttpRequest<?>, HttpResponse<?>>> extractors) {
        MicronautHttpClientAttributesGetter httpAttributesGetter = MicronautHttpClientAttributesGetter.INSTANCE;
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpClientAttributesGetter)httpAttributesGetter));
        builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientMetrics.get());
        builder.addAttributesExtractors(extractors);
        return builder.buildClientInstrumenter((TextMapSetter)HttpRequestSetter.INSTANCE);
    }

    @Client
    @Prototype
    AttributesExtractor<MutableHttpRequest<Object>, HttpResponse<Object>> peerServiceAttributesExtractor() {
        return PeerServiceAttributesExtractor.create((ServerAttributesGetter)MicronautHttpClientAttributesGetter.INSTANCE, (PeerServiceResolver)PeerServiceResolver.create(Collections.emptyMap()));
    }

    @Client
    @Prototype
    AttributesExtractor<MutableHttpRequest<Object>, HttpResponse<Object>> mutableHttpRequestHttpResponseHttpClientAttributesExtractorBuilder(@Nullable OpenTelemetryHttpClientConfig openTelemetryHttpClientConfig) {
        HttpClientAttributesExtractorBuilder httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)MicronautHttpClientAttributesGetter.INSTANCE);
        if (openTelemetryHttpClientConfig != null) {
            httpAttributesExtractorBuilder.setCapturedRequestHeaders(openTelemetryHttpClientConfig.getRequestHeaders());
            httpAttributesExtractorBuilder.setCapturedResponseHeaders(openTelemetryHttpClientConfig.getResponseHeaders());
        }
        return httpAttributesExtractorBuilder.build();
    }

    @Qualifier
    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Client {
    }
}

