/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.client;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.annotation.ContinueSpan;
import io.micronaut.tracing.opentelemetry.OpenTelemetryPropagationContext;
import io.micronaut.tracing.opentelemetry.instrument.http.AbstractOpenTelemetryFilter;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryExclusionsConfiguration;
import io.micronaut.tracing.opentelemetry.interceptor.AbstractOpenTelemetryTraceInterceptor;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.inject.Named;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@Filter(value={"${tracing.http.client.path:/**}"})
public final class OpenTelemetryClientFilter
extends AbstractOpenTelemetryFilter
implements HttpClientFilter {
    private final Instrumenter<MutableHttpRequest<?>, Object> instrumenter;

    public OpenTelemetryClientFilter(@Nullable OpenTelemetryExclusionsConfiguration exclusionsConfig, @Named(value="micronautHttpClientTelemetryInstrumenter") Instrumenter<MutableHttpRequest<?>, Object> instrumenter) {
        super(exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
        this.instrumenter = instrumenter;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        if (this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return chain.proceed(request);
        }
        Context context = this.instrumenter.start(parentContext, request);
        try (Scope ignored = context.makeCurrent();){
            Mono mono;
            block14: {
                this.handleContinueSpan(request);
                PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new OpenTelemetryPropagationContext(context)).propagate();
                try {
                    mono = Mono.from((Publisher)chain.proceed(request)).doOnNext(mutableHttpResponse -> this.instrumenter.end(context, (Object)request, mutableHttpResponse, null)).doOnError(throwable -> {
                        Span span = Span.fromContext((Context)context);
                        span.recordException(throwable);
                        span.setStatus(StatusCode.ERROR);
                        this.instrumenter.end(context, (Object)request, null, throwable);
                    });
                    if (ignore == null) break block14;
                }
                catch (Throwable throwable2) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                ignore.close();
            }
            return mono;
        }
    }

    private void handleContinueSpan(MutableHttpRequest<?> request) {
        MethodInvocationContext context;
        Object invocationContext = request.getAttribute((CharSequence)HttpAttributes.INVOCATION_CONTEXT).orElse(null);
        if (invocationContext instanceof MethodInvocationContext && (context = (MethodInvocationContext)invocationContext).hasAnnotation(ContinueSpan.class)) {
            AbstractOpenTelemetryTraceInterceptor.tagArguments((MethodInvocationContext)context);
        }
    }
}

