/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.server;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.web.router.UriRouteInfo;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
enum MicronautHttpServerAttributesGetter implements HttpServerAttributesGetter<HttpRequest<Object>, HttpResponse<Object>>
{
    INSTANCE;

    private static final Map<HttpVersion, String> PROTOCOL_VERSION;

    public String getHttpRequestMethod(HttpRequest<Object> request) {
        return request.getMethodName();
    }

    public List<String> getHttpRequestHeader(HttpRequest<Object> request, String name) {
        return request.getHeaders().getAll((CharSequence)name);
    }

    public Integer getHttpResponseStatusCode(HttpRequest<Object> request, HttpResponse<Object> response, @Nullable Throwable error) {
        return response.code();
    }

    public List<String> getHttpResponseHeader(HttpRequest<Object> request, HttpResponse<Object> response, String name) {
        return response.getHeaders().getAll((CharSequence)name);
    }

    @Nullable
    public String getNetworkProtocolVersion(HttpRequest<Object> request, @Nullable HttpResponse<Object> response) {
        return PROTOCOL_VERSION.get(request.getHttpVersion());
    }

    public String getUrlPath(HttpRequest<Object> request) {
        return request.getPath();
    }

    @Nullable
    public String getUrlQuery(HttpRequest<Object> request) {
        return request.getUri().getRawQuery();
    }

    public String getHttpRoute(HttpRequest<Object> request) {
        Optional<String> routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO).filter(UriRouteInfo.class::isInstance).map(ri -> (UriRouteInfo)ri).map(UriRouteInfo::getUriMatchTemplate).map(UriMatchTemplate::toPathString);
        return routeInfo.orElseGet(() -> request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE).map(Object::toString).orElse(null));
    }

    public String getUrlScheme(HttpRequest<Object> request) {
        return request.getUri().getScheme();
    }

    static {
        PROTOCOL_VERSION = Map.of(HttpVersion.HTTP_1_0, "1.0", HttpVersion.HTTP_1_1, "1.1", HttpVersion.HTTP_2_0, "2.0");
    }
}

