/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http.server;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.tracing.opentelemetry.OpenTelemetryPropagationContext;
import io.micronaut.tracing.opentelemetry.instrument.http.AbstractOpenTelemetryFilter;
import io.micronaut.tracing.opentelemetry.instrument.util.OpenTelemetryExclusionsConfiguration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.inject.Named;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@Filter(value={"${tracing.http.server.path:/**}"})
@Requires(beans={Tracer.class})
public final class OpenTelemetryServerFilter
extends AbstractOpenTelemetryFilter
implements HttpServerFilter {
    private static final String APPLIED = OpenTelemetryServerFilter.class.getName() + "-applied";
    private static final String CONTINUE = OpenTelemetryServerFilter.class.getName() + "-continue";
    private final Instrumenter<HttpRequest<?>, Object> instrumenter;

    public OpenTelemetryServerFilter(@Nullable OpenTelemetryExclusionsConfiguration exclusionsConfig, @Named(value="micronautHttpServerTelemetryInstrumenter") Instrumenter<HttpRequest<?>, Object> instrumenter) {
        super(exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
        this.instrumenter = instrumenter;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        boolean applied = request.getAttribute((CharSequence)APPLIED, Boolean.class).orElse(false);
        boolean continued = request.getAttribute((CharSequence)CONTINUE, Boolean.class).orElse(false);
        if (applied && !continued || this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        request.setAttribute((CharSequence)APPLIED, (Object)true);
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return chain.proceed(request);
        }
        Context context = this.instrumenter.start(parentContext, request);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new OpenTelemetryPropagationContext(context)).propagate();){
            PropagatedContext propagatedContext = PropagatedContext.get();
            Mono mono = Mono.from((Publisher)chain.proceed(request)).doOnNext(mutableHttpResponse -> mutableHttpResponse.getAttribute((CharSequence)HttpAttributes.EXCEPTION, Exception.class).ifPresentOrElse(e -> this.onError(request, context, (MutableHttpResponse<?>)mutableHttpResponse, (Throwable)e), () -> {
                if (mutableHttpResponse.status().getCode() >= 400) {
                    this.onError(request, context, (MutableHttpResponse<?>)mutableHttpResponse, null);
                } else {
                    this.instrumenter.end(context, (Object)request, mutableHttpResponse, null);
                }
            })).doOnError(throwable -> this.onError(request, context, null, (Throwable)throwable)).contextWrite(ctx -> ReactorPropagation.addPropagatedContext((reactor.util.context.Context)ctx, (PropagatedContext)propagatedContext));
            return mono;
        }
    }

    private void onError(HttpRequest<?> request, Context context, @Nullable MutableHttpResponse<?> mutableHttpResponse, @Nullable Throwable e) {
        Span span = Span.fromContext((Context)context);
        if (e != null) {
            span.recordException(e);
        }
        span.setStatus(StatusCode.ERROR);
        this.instrumenter.end(context, request, mutableHttpResponse, e);
        request.setAttribute((CharSequence)CONTINUE, (Object)true);
    }
}

