/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.filter.HttpFilter;
import java.util.function.Predicate;

@Internal
public abstract class AbstractOpenTelemetryFilter
implements HttpFilter {
    public static final String CLIENT_PATH = "${tracing.http.client.path:/**}";
    public static final String SERVER_PATH = "${tracing.http.server.path:/**}";
    public static final String TAG_ERROR = "error";
    @Nullable
    private final Predicate<String> pathExclusionTest;

    protected AbstractOpenTelemetryFilter(@Nullable Predicate<String> pathExclusionTest) {
        this.pathExclusionTest = pathExclusionTest;
    }

    protected boolean shouldExclude(@Nullable String path) {
        return this.pathExclusionTest != null && path != null && this.pathExclusionTest.test(path);
    }
}

