/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.tracing.opentelemetry.ResourceProvider;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.stream.Collectors;

@Factory
public class DefaultOpenTelemetryFactory {
    private static final String SERVICE_NAME_KEY = "otel.service.name";
    private static final String DEFAULT_TRACES_EXPORTER = "otel.traces.exporter";
    private static final String DEFAULT_METRICS_EXPORTER = "otel.metrics.exporter";
    private static final String DEFAULT_LOGS_EXPORTER = "otel.logs.exporter";
    private static final String REGISTER_GLOBAL = "otel.register.global";
    private static final String NONE = "none";

    @Singleton
    protected OpenTelemetry defaultOpenTelemetry(ApplicationConfiguration applicationConfiguration, @Property(name="otel") @MapFormat(transformation=MapFormat.MapTransformation.FLAT) Map<String, String> otelConfig, @Nullable IdGenerator idGenerator, @Nullable SpanProcessor spanProcessor, @Nullable ResourceProvider resourceProvider, @Nullable Sampler sampler) {
        Map<String, String> otel = otelConfig.entrySet().stream().collect(Collectors.toMap(e -> "otel." + (String)e.getKey(), Map.Entry::getValue));
        otel.putIfAbsent(SERVICE_NAME_KEY, applicationConfiguration.getName().orElse(""));
        otel.putIfAbsent(DEFAULT_TRACES_EXPORTER, NONE);
        otel.putIfAbsent(DEFAULT_METRICS_EXPORTER, NONE);
        otel.putIfAbsent(DEFAULT_LOGS_EXPORTER, NONE);
        AutoConfiguredOpenTelemetrySdkBuilder sdk = AutoConfiguredOpenTelemetrySdk.builder();
        if (Boolean.parseBoolean(otel.getOrDefault(REGISTER_GLOBAL, "false"))) {
            sdk.setResultAsGlobal();
        }
        sdk.addPropertiesSupplier(() -> otel).addTracerProviderCustomizer((tracerProviderBuilder, ignored) -> {
            if (idGenerator != null) {
                tracerProviderBuilder.setIdGenerator(idGenerator);
            }
            if (spanProcessor != null) {
                tracerProviderBuilder.addSpanProcessor(spanProcessor);
            }
            if (resourceProvider != null) {
                tracerProviderBuilder.setResource(resourceProvider.resource());
            }
            if (sampler != null) {
                tracerProviderBuilder.setSampler(sampler);
            }
            return tracerProviderBuilder;
        });
        return sdk.build().getOpenTelemetrySdk();
    }

    @PreDestroy
    void resetForTest(Environment environment) {
        if (environment.getActiveNames().contains("test")) {
            GlobalOpenTelemetry.resetForTest();
            GlobalEventEmitterProvider.resetForTest();
        }
    }
}

