/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.runtime.ApplicationConfiguration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import jakarta.inject.Singleton;

@Factory
public class DefaultTelemetryTracer {
    private final String applicationName;

    DefaultTelemetryTracer(ApplicationConfiguration applicationConfiguration) {
        this.applicationName = applicationConfiguration.getName().orElse("");
    }

    @Singleton
    @Primary
    @Requires(missingBeans={Tracer.class})
    Tracer defaultTracer(@NonNull OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(this.applicationName);
    }
}

