/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.instrument.util;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.util.ClassAndMethod;
import jakarta.inject.Named;

@Factory
public final class MicronautCodeTelemetryFactory {
    private static final String INSTRUMENTATION_NAME = "io.micronaut.code";

    @Prototype
    @Requires(beans={OpenTelemetry.class})
    @Named(value="micronautCodeTelemetryInstrumenter")
    public Instrumenter<ClassAndMethod, Object> instrumenter(OpenTelemetry openTelemetry) {
        CodeAttributesGetter classAndMethodAttributesGetter = ClassAndMethod.codeAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)CodeSpanNameExtractor.create((CodeAttributesGetter)classAndMethodAttributesGetter));
        return builder.addOperationMetrics(HttpClientMetrics.get()).buildInstrumenter();
    }
}

