/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.interceptor;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.util.StringUtils;
import io.micronaut.tracing.annotation.NewSpan;
import io.micronaut.tracing.opentelemetry.OpenTelemetryPropagationContext;
import io.micronaut.tracing.opentelemetry.interceptor.AbstractOpenTelemetryTraceInterceptor;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.ClassAndMethod;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
@Singleton
@Requires(beans={Tracer.class})
@InterceptorBean(value={NewSpan.class})
public final class NewSpanOpenTelemetryTraceInterceptor
extends AbstractOpenTelemetryTraceInterceptor {
    private final ConversionService conversionService;

    public NewSpanOpenTelemetryTraceInterceptor(@Named(value="micronautCodeTelemetryInstrumenter") Instrumenter<ClassAndMethod, Object> instrumenter, ConversionService conversionService) {
        super(instrumenter);
        this.conversionService = conversionService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        boolean isNew;
        AnnotationValue newSpan = context.getAnnotation(NewSpan.class);
        boolean bl = isNew = newSpan != null;
        if (!isNew) {
            return context.proceed();
        }
        String operationName = newSpan.stringValue().orElse("");
        ClassAndMethod basicClassAndMethod = ClassAndMethod.create((Class)context.getDeclaringType(), (String)context.getMethodName());
        ClassAndMethod classAndMethod = StringUtils.isNotEmpty((CharSequence)operationName) ? ClassAndMethod.create((Class)basicClassAndMethod.declaringClass(), (String)(basicClassAndMethod.methodName() + "#" + operationName)) : basicClassAndMethod;
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        Context currentContext = Context.current();
        if (!this.instrumenter.shouldStart(currentContext, (Object)classAndMethod)) {
            return context.proceed();
        }
        Context newContext = this.instrumenter.start(currentContext, (Object)classAndMethod);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new OpenTelemetryPropagationContext(newContext)).propagate();){
            NewSpanOpenTelemetryTraceInterceptor.tagArguments(context);
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    Object object = interceptedMethod.handleResult((Object)Flux.from((Publisher)interceptedMethod.interceptResultAsPublisher()).doOnNext(value -> this.instrumenter.end(newContext, (Object)classAndMethod, value, null)).doOnComplete(() -> this.instrumenter.end(newContext, (Object)classAndMethod, null, null)).doOnError(throwable -> this.instrumenter.end(newContext, (Object)classAndMethod, null, throwable)));
                    return object;
                }
                case COMPLETION_STAGE: {
                    CompletionStage<Object> completionStage = interceptedMethod.interceptResultAsCompletionStage();
                    if (completionStage != null) {
                        completionStage = completionStage.whenComplete((o, throwable) -> {
                            if (throwable != null) {
                                this.instrumenter.end(newContext, (Object)classAndMethod, null, throwable);
                            } else {
                                this.instrumenter.end(newContext, (Object)classAndMethod, o, null);
                            }
                        });
                    }
                    Object object = interceptedMethod.handleResult((Object)completionStage);
                    return object;
                }
                case SYNCHRONOUS: {
                    Object response = context.proceed();
                    this.instrumenter.end(newContext, (Object)classAndMethod, response, null);
                    Object object = response;
                    return object;
                }
            }
            Object object = interceptedMethod.unsupported();
            return object;
        }
        catch (Exception e) {
            this.instrumenter.end(newContext, (Object)classAndMethod, null, (Throwable)e);
            return interceptedMethod.handleException(e);
        }
    }
}

