/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.xray;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;

@Internal
@Requires(classes={AwsSdkTelemetry.class, SdkClientBuilder.class})
@Singleton
public class SdkClientBuilderListener
implements BeanCreatedEventListener<SdkClientBuilder<?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(SdkClientBuilderListener.class);
    private final BeanProvider<OpenTelemetry> openTelemetry;

    public SdkClientBuilderListener(BeanProvider<OpenTelemetry> openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public SdkClientBuilder<?, ?> onCreated(BeanCreatedEvent<SdkClientBuilder<?, ?>> event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Registering OpenTelemetry tracing interceptor to {}", (Object)((SdkClientBuilder)event.getBean()).getClass().getSimpleName());
        }
        return ((SdkClientBuilder)event.getBean()).overrideConfiguration(builder -> builder.addExecutionInterceptor(AwsSdkTelemetry.create((OpenTelemetry)((OpenTelemetry)this.openTelemetry.get())).newExecutionInterceptor()));
    }
}

