/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentelemetry.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.type.Argument;
import io.micronaut.tracing.annotation.SpanTag;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.ClassAndMethod;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import jakarta.inject.Named;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractOpenTelemetryTraceInterceptor
implements MethodInterceptor<Object, Object> {
    protected final Instrumenter<ClassAndMethod, Object> instrumenter;

    protected AbstractOpenTelemetryTraceInterceptor(@Named(value="micronautCodeTelemetryInstrumenter") Instrumenter<ClassAndMethod, Object> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public int getOrder() {
        return InterceptPhase.TRACE.getPosition();
    }

    public static void tagArguments(MethodInvocationContext<?, ?> context) {
        Argument[] arguments = context.getArguments();
        Object[] parameterValues = context.getParameterValues();
        for (int i = 0; i < arguments.length; ++i) {
            Object v;
            Argument argument = arguments[i];
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (!annotationMetadata.hasAnnotation(SpanTag.class) || (v = parameterValues[i]) == null) continue;
            String tagName = annotationMetadata.stringValue(SpanTag.class).orElse(argument.getName());
            Span span = Span.current();
            span.setAttribute(tagName, v.toString());
        }
    }
}

