/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentracing.instrument.http;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.opentracing.OpenTracingPropagationContext;
import io.micronaut.tracing.opentracing.instrument.http.AbstractOpenTracingFilter;
import io.micronaut.tracing.opentracing.instrument.http.HttpHeadersTextMap;
import io.micronaut.tracing.opentracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.opentracing.instrument.http.TracingExclusionsConfiguration;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.propagation.Format;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
@Filter(value={"${tracing.http.client.path:/**}"})
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={NoopTracer.class})})
public final class OpenTracingClientFilter
extends AbstractOpenTracingFilter
implements HttpClientFilter {
    public OpenTracingClientFilter(Tracer tracer, ConversionService conversionService, @Nullable TracingExclusionsConfiguration exclusionsConfig) {
        super(tracer, conversionService, exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        if (this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        Span currentSpan = this.tracer.activeSpan();
        SpanContext activeContext = currentSpan == null ? null : currentSpan.context();
        Tracer.SpanBuilder spanBuilder = this.newSpan((HttpRequest<?>)request, activeContext);
        if (currentSpan != null) {
            spanBuilder.asChildOf(currentSpan);
        }
        Span span = spanBuilder.start();
        span.setTag("http.client", true);
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN_CONTEXT, (Object)span.context());
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new OpenTracingPropagationContext(this.tracer, span)).propagate();){
            Mono mono = Mono.from((Publisher)chain.proceed(request)).doOnSubscribe(subscription -> this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersTextMap((HttpHeaders)request.getHeaders()))).doOnNext(httpResponse -> this.setResponseTags((HttpRequest<?>)request, (HttpResponse<?>)httpResponse, span)).doOnError(throwable -> {
                if (throwable instanceof HttpClientResponseException) {
                    HttpClientResponseException e = (HttpClientResponseException)throwable;
                    HttpResponse response = e.getResponse();
                    this.setResponseTags((HttpRequest<?>)request, (HttpResponse<?>)response, span);
                }
                this.setErrorTags(span, (Throwable)throwable);
            }).doOnTerminate(() -> ((Span)span).finish());
            return mono;
        }
    }
}

