/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentracing.instrument.http;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.tracing.opentracing.OpenTracingPropagationContext;
import io.micronaut.tracing.opentracing.instrument.http.AbstractOpenTracingFilter;
import io.micronaut.tracing.opentracing.instrument.http.HttpHeadersTextMap;
import io.micronaut.tracing.opentracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.opentracing.instrument.http.TracingExclusionsConfiguration;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.propagation.Format;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

@Internal
@Filter(value={"${tracing.http.server.path:/**}"})
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={NoopTracer.class})})
public final class OpenTracingServerFilter
extends AbstractOpenTracingFilter
implements HttpServerFilter {
    public OpenTracingServerFilter(Tracer tracer, ConversionService conversionService, @Nullable TracingExclusionsConfiguration exclusionsConfig) {
        super(tracer, conversionService, exclusionsConfig == null ? null : exclusionsConfig.exclusionTest());
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        if (this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        Span currentSpan = this.tracer.activeSpan();
        Tracer.SpanBuilder spanBuilder = this.newSpan(request, this.initSpanContext(request));
        if (currentSpan != null) {
            spanBuilder.asChildOf(currentSpan);
        }
        Span span = spanBuilder.start();
        span.setTag("http.server", true);
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN_CONTEXT, (Object)span.context());
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new OpenTracingPropagationContext(this.tracer, span)).propagate();){
            PropagatedContext propagatedContext = PropagatedContext.get();
            Mono mono = Mono.from((Publisher)chain.proceed(request)).doOnNext(response -> {
                this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersTextMap((HttpHeaders)response.getHeaders()));
                this.setResponseTags(request, (HttpResponse<?>)response, span);
            }).doOnError(throwable -> this.setErrorTags(span, (Throwable)throwable)).doOnTerminate(() -> ((Span)span).finish()).contextWrite(ctx -> ReactorPropagation.addPropagatedContext((Context)ctx, (PropagatedContext)propagatedContext));
            return mono;
        }
    }

    public int getOrder() {
        return ServerFilterPhase.TRACING.order();
    }

    @NonNull
    private SpanContext initSpanContext(@NonNull HttpRequest<?> request) {
        SpanContext spanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersTextMap(request.getHeaders()));
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN_CONTEXT, (Object)spanContext);
        return spanContext;
    }
}

