/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.opentracing.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.tracing.annotation.SpanTag;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
@Requires(beans={Tracer.class})
public abstract class AbstractTraceInterceptor
implements MethodInterceptor<Object, Object> {
    public static final String CLASS_TAG = "class";
    public static final String METHOD_TAG = "method";
    protected final Tracer tracer;
    protected final ConversionService conversionService;

    protected AbstractTraceInterceptor(Tracer tracer, ConversionService conversionService) {
        this.tracer = tracer;
        this.conversionService = conversionService;
    }

    public int getOrder() {
        return InterceptPhase.TRACE.getPosition();
    }

    protected final void populateTags(MethodInvocationContext<Object, Object> context, Span span) {
        span.setTag(CLASS_TAG, context.getDeclaringType().getSimpleName());
        span.setTag(METHOD_TAG, context.getMethodName());
        this.tagArguments(span, context);
    }

    public static void logError(Span span, Throwable e) {
        HashMap fields = CollectionUtils.newHashMap((int)2);
        fields.put("error.object", e);
        String message = e.getMessage();
        if (message != null) {
            fields.put("message", message);
        }
        span.log((Map)fields);
    }

    protected final void tagArguments(Span span, MethodInvocationContext<Object, Object> context) {
        Argument[] arguments = context.getArguments();
        Object[] parameterValues = context.getParameterValues();
        for (int i = 0; i < arguments.length; ++i) {
            Object v;
            Argument argument = arguments[i];
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (!annotationMetadata.hasAnnotation(SpanTag.class) || (v = parameterValues[i]) == null) continue;
            String tagName = annotationMetadata.stringValue(SpanTag.class).orElse(argument.getName());
            span.setTag(tagName, v.toString());
        }
    }
}

