/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.zipkin.http.client;

import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.tracing.zipkin.http.client.HttpClientSenderConfiguration;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
@Requires(beans={HttpClientSenderConfiguration.class})
public class ZipkinServiceInstanceList
implements ServiceInstanceList {
    public static final String SERVICE_ID = "zipkin";
    private final HttpClientSenderConfiguration configuration;

    public ZipkinServiceInstanceList(HttpClientSenderConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getID() {
        return SERVICE_ID;
    }

    public List<ServiceInstance> getInstances() {
        List<URI> servers = this.configuration.getBuilder().getServers();
        return servers.stream().map(uri -> ServiceInstance.builder((String)SERVICE_ID, (URI)uri).build()).collect(Collectors.toList());
    }
}

