/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.tracing.brave.instrument.http.HttpServerTracingPublisher;
import io.micronaut.tracing.instrument.http.OpenTracingServerFilter;
import io.micronaut.tracing.instrument.http.TracingExclusionsConfiguration;
import io.opentracing.Tracer;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.server.path:/**}"})
@Requires(beans={HttpServerHandler.class})
@Replaces(value=OpenTracingServerFilter.class)
public class BraveTracingServerFilter
implements HttpServerFilter {
    private final HttpTracing httpTracing;
    private final Tracer openTracer;
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler;
    @Nullable
    private final Predicate<String> pathExclusionTest;

    public BraveTracingServerFilter(HttpTracing httpTracing, Tracer openTracer, HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler) {
        this(httpTracing, openTracer, serverHandler, null);
    }

    @Inject
    public BraveTracingServerFilter(HttpTracing httpTracing, Tracer openTracer, HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler, @Nullable TracingExclusionsConfiguration exclusionsConfiguration) {
        this.httpTracing = httpTracing;
        this.openTracer = openTracer;
        this.serverHandler = serverHandler;
        this.pathExclusionTest = exclusionsConfiguration == null ? null : exclusionsConfiguration.exclusionTest();
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        if (this.shouldExclude(request.getPath())) {
            return chain.proceed(request);
        }
        HttpServerRequest httpServerRequest = this.mapRequest(request);
        Span span = this.serverHandler.handleReceive(httpServerRequest);
        return new HttpServerTracingPublisher(chain.proceed(request), request, this.serverHandler, this.httpTracing, this.openTracer, span);
    }

    public int getOrder() {
        return ServerFilterPhase.TRACING.order();
    }

    private boolean shouldExclude(@Nullable String path) {
        return this.pathExclusionTest != null && path != null && this.pathExclusionTest.test(path);
    }

    private HttpServerRequest mapRequest(final HttpRequest<?> request) {
        return new HttpServerRequest(){

            public String method() {
                return request.getMethodName();
            }

            public String path() {
                return request.getPath();
            }

            public String url() {
                return request.getUri().toString();
            }

            public String header(String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Object unwrap() {
                return request;
            }
        };
    }
}

