/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.instrument.util.ScopePropagationPublisher;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class HttpServerTracingPublisher
implements Publishers.MicronautPublisher<MutableHttpResponse<?>> {
    private final Publisher<MutableHttpResponse<?>> publisher;
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler;
    private final HttpRequest<?> request;
    private final Tracer tracer;
    private final io.opentracing.Tracer openTracer;
    private final Span initialSpan;

    HttpServerTracingPublisher(Publisher<MutableHttpResponse<?>> publisher, HttpRequest<?> request, HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler, HttpTracing httpTracing, io.opentracing.Tracer openTracer, Span initialSpan) {
        this.publisher = publisher;
        this.request = request;
        this.initialSpan = initialSpan;
        this.serverHandler = serverHandler;
        this.openTracer = openTracer;
        this.tracer = httpTracing.tracing().tracer();
    }

    public void subscribe(Subscriber<? super MutableHttpResponse<?>> actual) {
        Span span = this.initialSpan;
        this.request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            this.publisher.subscribe((Subscriber)new TracingSubscriber(span, actual));
        }
    }

    private HttpServerResponse mapResponse(final HttpRequest<?> request, final HttpResponse<?> response) {
        return new HttpServerResponse(){

            public Object unwrap() {
                return response;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return response.getStatus().getCode();
            }
        };
    }

    private HttpServerResponse mapResponse(final HttpRequest<?> request, final int statusCode, final Throwable error) {
        return new HttpServerResponse(){

            public Throwable error() {
                return error;
            }

            public Object unwrap() {
                return this;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return statusCode;
            }
        };
    }

    private final class TracingSubscriber
    implements Subscriber<MutableHttpResponse<?>> {
        private final Subscriber<? super MutableHttpResponse<?>> actual;
        private final Span span;

        private TracingSubscriber(Span span, Subscriber<? super MutableHttpResponse<?>> actual) {
            this.actual = actual;
            this.span = span;
        }

        public void onSubscribe(Subscription s) {
            try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(this.span);){
                this.actual.onSubscribe(s);
            }
        }

        public void onNext(MutableHttpResponse<?> response) {
            try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(this.span);){
                Optional throwable;
                Object o;
                Optional body = response.getBody();
                if (body.isPresent() && Publishers.isConvertibleToPublisher(o = body.get())) {
                    Class<?> type = o.getClass();
                    Publisher resultPublisher = (Publisher)Publishers.convertPublisher(o, Publisher.class);
                    ScopePropagationPublisher scopedPublisher = new ScopePropagationPublisher(resultPublisher, HttpServerTracingPublisher.this.openTracer, HttpServerTracingPublisher.this.openTracer.activeSpan());
                    response.body(Publishers.convertPublisher((Object)scopedPublisher, type));
                }
                if ((throwable = response.getAttribute((CharSequence)HttpAttributes.EXCEPTION, Throwable.class)).isPresent()) {
                    int statusCode = 500;
                    Throwable error = (Throwable)throwable.get();
                    if (error instanceof HttpStatusException) {
                        statusCode = ((HttpStatusException)error).getStatus().getCode();
                    }
                    HttpServerTracingPublisher.this.serverHandler.handleSend(HttpServerTracingPublisher.this.mapResponse(HttpServerTracingPublisher.this.request, statusCode, error), this.span);
                } else {
                    HttpServerTracingPublisher.this.serverHandler.handleSend(HttpServerTracingPublisher.this.mapResponse(HttpServerTracingPublisher.this.request, response), this.span);
                }
                this.actual.onNext(response);
            }
        }

        public void onError(Throwable error) {
            this.actual.onError(error);
        }

        public void onComplete() {
            this.actual.onComplete();
        }
    }
}

