/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.sender;

import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import jakarta.inject.Provider;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;

public final class HttpClientSender
extends Sender {
    private final Encoding encoding;
    private final int messageMaxBytes;
    private final boolean compressionEnabled;
    private final URI endpoint;
    private final List<InvocationInstrumenterFactory> factories;
    private final Provider<LoadBalancerResolver> loadBalancerResolver;
    private final HttpClientConfiguration clientConfiguration;
    private HttpClient httpClient;

    private HttpClientSender(Encoding encoding, int messageMaxBytes, boolean compressionEnabled, HttpClientConfiguration clientConfiguration, Provider<LoadBalancerResolver> loadBalancerResolver, String path, List<InvocationInstrumenterFactory> factories) {
        this.loadBalancerResolver = loadBalancerResolver;
        this.clientConfiguration = clientConfiguration;
        this.encoding = encoding;
        this.messageMaxBytes = messageMaxBytes;
        this.compressionEnabled = compressionEnabled;
        this.factories = factories;
        this.endpoint = path == null ? URI.create("/api/v2/spans") : URI.create(path);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return this.encoding().listSizeInBytes(encodedSpans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        this.initHttpClient();
        if (this.httpClient == null || !this.httpClient.isRunning()) {
            throw new IllegalStateException("HTTP Client Closed");
        }
        return new HttpCall(this.httpClient, this.endpoint, this.compressionEnabled, encodedSpans);
    }

    public CheckResult check() {
        this.initHttpClient();
        if (this.httpClient == null) {
            return CheckResult.failed((Throwable)new NoAvailableServiceException("zipkin"));
        }
        try {
            HttpResponse response = this.httpClient.toBlocking().exchange((HttpRequest)HttpRequest.POST((URI)this.endpoint, Collections.emptyList()));
            if (response.getStatus().getCode() >= HttpStatus.MULTIPLE_CHOICES.getCode()) {
                throw new IllegalStateException("check response failed: " + response);
            }
            return CheckResult.OK;
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    private void initHttpClient() {
        if (this.httpClient != null) {
            return;
        }
        Optional loadBalancer = ((LoadBalancerResolver)this.loadBalancerResolver.get()).resolve(new String[]{"zipkin"});
        this.httpClient = loadBalancer.map(lb -> new DefaultHttpClient(lb, this.clientConfiguration, this.factories)).orElse(null);
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public static class Builder {
        public static final String DEFAULT_PATH = "/api/v2/spans";
        public static final String DEFAULT_SERVER_URL = "http://localhost:9411";
        private Encoding encoding = Encoding.JSON;
        private int messageMaxBytes = 5120;
        private String path = "/api/v2/spans";
        private boolean compressionEnabled = true;
        private List<URI> servers = Collections.singletonList(URI.create("http://localhost:9411"));
        private final HttpClientConfiguration clientConfiguration;
        private List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

        public Builder(HttpClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
        }

        public List<URI> getServers() {
            return this.servers;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding != null) {
                this.encoding = encoding;
            }
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder server(URI endpoint) {
            if (endpoint != null) {
                this.servers = Collections.singletonList(endpoint);
            }
            return this;
        }

        public Builder url(URI endpoint) {
            return this.server(endpoint);
        }

        public Builder urls(List<URI> urls) {
            if (CollectionUtils.isNotEmpty(urls)) {
                this.servers = Collections.unmodifiableList(urls);
            }
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder invocationInstrumenterFactories(List<InvocationInstrumenterFactory> factories) {
            this.invocationInstrumenterFactories = factories;
            return this;
        }

        public HttpClientSender build(Provider<LoadBalancerResolver> loadBalancerResolver) {
            return new HttpClientSender(this.encoding, this.messageMaxBytes, this.compressionEnabled, this.clientConfiguration, loadBalancerResolver, this.path, this.invocationInstrumenterFactories);
        }
    }

    private static class HttpCall
    extends Call<Void> {
        private final HttpClient httpClient;
        private final URI endpoint;
        private final boolean compressionEnabled;
        private final List<byte[]> encodedSpans;
        private final AtomicReference<Subscription> subscription = new AtomicReference();
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        HttpCall(HttpClient httpClient, URI endpoint, boolean compressionEnabled, List<byte[]> encodedSpans) {
            this.httpClient = httpClient;
            this.endpoint = endpoint;
            this.compressionEnabled = compressionEnabled;
            this.encodedSpans = encodedSpans;
        }

        public Void execute() {
            HttpResponse response = this.httpClient.toBlocking().exchange(this.prepareRequest());
            if (response.getStatus().getCode() >= HttpStatus.BAD_REQUEST.getCode()) {
                throw new IllegalStateException("Response return invalid status code: " + response.getStatus());
            }
            return null;
        }

        public void enqueue(final Callback<Void> callback) {
            Publisher publisher = this.httpClient.exchange(this.prepareRequest());
            publisher.subscribe((Subscriber)new Subscriber<HttpResponse<ByteBuffer>>(){

                public void onSubscribe(Subscription s) {
                    subscription.set(s);
                    s.request(1L);
                }

                public void onNext(HttpResponse<ByteBuffer> response) {
                    if (response.getStatus().getCode() >= HttpStatus.BAD_REQUEST.getCode()) {
                        callback.onError((Throwable)new IllegalStateException("Response return invalid status code: " + response.getStatus()));
                    } else {
                        callback.onSuccess(null);
                    }
                }

                public void onError(Throwable t) {
                    callback.onError(t);
                }

                public void onComplete() {
                }
            });
        }

        public void cancel() {
            Subscription s = this.subscription.get();
            if (s != null) {
                this.cancelled.set(true);
                s.cancel();
            }
        }

        public boolean isCanceled() {
            Subscription s = this.subscription.get();
            return s != null && this.cancelled.get();
        }

        public Call<Void> clone() {
            return new HttpCall(this.httpClient, this.endpoint, this.compressionEnabled, this.encodedSpans);
        }

        protected MutableHttpRequest<Flux<Object>> prepareRequest() {
            return HttpRequest.POST((URI)this.endpoint, this.spanReactiveSequence());
        }

        private Flux<Object> spanReactiveSequence() {
            return Flux.create(emitter -> {
                for (byte[] encodedSpan : this.encodedSpans) {
                    emitter.next((Object)encodedSpan);
                }
                emitter.complete();
            }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
        }
    }
}

