/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.sender;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.tracing.brave.BraveTracerConfiguration;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.stream.Collectors;
import zipkin2.reporter.Sender;

@Factory
@Requires(beans={BraveTracerConfiguration.HttpClientSenderConfiguration.class})
public class HttpClientSenderFactory {
    private final BraveTracerConfiguration.HttpClientSenderConfiguration configuration;
    private final BeanProvider<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    protected HttpClientSenderFactory(BraveTracerConfiguration.HttpClientSenderConfiguration configuration, BeanProvider<InvocationInstrumenterFactory> factories) {
        this.configuration = configuration;
        this.invocationInstrumenterFactories = factories;
    }

    @Singleton
    @Requires(missingBeans={Sender.class})
    Sender zipkinSender(Provider<LoadBalancerResolver> loadBalancerResolver) {
        return this.configuration.getBuilder().invocationInstrumenterFactories(this.invocationInstrumenterFactories.stream().collect(Collectors.toList())).build(loadBalancerResolver);
    }
}

