/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.aop.Intercepted;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentValue;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.ProxyBeanDefinition;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.validation.BeanDefinitionValidator;
import io.micronaut.validation.annotation.ValidatedElement;
import io.micronaut.validation.validator.DefaultConstraintDescriptor;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.IntrospectedBeanDescriptor;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.Validator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import jakarta.inject.Singleton;
import jakarta.validation.ClockProvider;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Valid;
import jakarta.validation.ValidationException;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.ElementDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import jakarta.validation.metadata.MethodType;
import jakarta.validation.metadata.PropertyDescriptor;
import jakarta.validation.metadata.Scope;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Primary
@Requires(property="micronaut.validator.enabled", value="true", defaultValue="true")
public class DefaultValidator
implements Validator,
ExecutableMethodValidator,
ReactiveValidator,
AnnotatedElementValidator,
BeanDefinitionValidator {
    private static final Map<Class<?>, List<Class<?>>> GROUP_SEQUENCES = new ConcurrentHashMap();
    private static final List<Class<?>> DEFAULT_GROUPS = Collections.singletonList(Default.class);
    private final ConstraintValidatorRegistry constraintValidatorRegistry;
    private final ClockProvider clockProvider;
    private final ValueExtractorRegistry valueExtractorRegistry;
    private final TraversableResolver traversableResolver;
    private final ExecutionHandleLocator executionHandleLocator;
    private final MessageSource messageSource;
    private final ConversionService conversionService;
    private final BeanIntrospector beanIntrospector;

    public DefaultValidator(@NonNull ValidatorConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.constraintValidatorRegistry = configuration.getConstraintValidatorRegistry();
        this.clockProvider = configuration.getClockProvider();
        this.valueExtractorRegistry = configuration.getValueExtractorRegistry();
        this.traversableResolver = configuration.getTraversableResolver();
        this.executionHandleLocator = configuration.getExecutionHandleLocator();
        this.messageSource = configuration.getMessageSource();
        this.conversionService = configuration.getConversionService();
        this.beanIntrospector = configuration.getBeanIntrospector();
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull T object, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"object", object);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            throw new ValidationException("Bean introspection not found for the class: " + object.getClass());
        }
        return this.validate(introspection, object, groups);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validate(@NonNull BeanIntrospection<T> introspection, @NonNull T object, Class<?> ... groups) {
        if (introspection == null) {
            throw new ValidationException("Passed object [" + object + "] cannot be introspected. Please annotate with @Introspected");
        }
        for (Class<?>[] groupSequence : this.findGroupSequences(groups)) {
            DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(object, groupSequence);
            this.doValidate(context, introspection, object);
            if (context.overallViolations.isEmpty()) continue;
            return context.overallViolations;
        }
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateProperty(@NonNull T object, @NonNull String propertyName, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"object", object);
        ArgumentUtils.requireNonNull((String)"propertyName", (Object)propertyName);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(object);
        if (introspection == null) {
            throw new ValidationException("Passed object [" + object + "] cannot be introspected. Please annotate with @Introspected");
        }
        Optional property = introspection.getProperty(propertyName);
        if (property.isEmpty()) {
            return Collections.emptySet();
        }
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(object, groups);
        this.visitProperty(context, object, (BeanProperty)property.get());
        return Collections.unmodifiableSet(context.overallViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateValue(@NonNull Class<T> beanType, @NonNull String propertyName, @Nullable Object value, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"beanType", beanType);
        ArgumentUtils.requireNonNull((String)"propertyName", (Object)propertyName);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(beanType);
        if (introspection == null) {
            throw new ValidationException("Passed bean type [" + beanType + "] cannot be introspected. Please annotate with @Introspected");
        }
        BeanProperty beanProperty = (BeanProperty)introspection.getProperty(propertyName).orElseThrow(() -> new ValidationException("No property [" + propertyName + "] found on type: " + beanType));
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(beanType, groups);
        context.addPropertyNode(beanProperty.getName());
        try {
            this.visitElement(context, null, beanProperty.asArgument(), value);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(context.overallViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Set<String> validatedAnnotatedElement(@NonNull AnnotatedElement element, @Nullable Object value) {
        ArgumentUtils.requireNonNull((String)"element", (Object)element);
        if (!element.getAnnotationMetadata().hasStereotype(Constraint.class)) {
            return Collections.emptySet();
        }
        DefaultConstraintValidatorContext<Object> context = new DefaultConstraintValidatorContext<Object>(value, new Class[0]);
        Argument type = value != null ? Argument.of(value.getClass(), (AnnotationMetadata)element.getAnnotationMetadata(), (Argument[])new Argument[0]) : Argument.OBJECT_ARGUMENT;
        context.addPropertyNode(element.getName());
        try {
            this.visitElement(context, element, type, value);
        }
        finally {
            context.removeLast();
        }
        return context.overallViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NonNull
    public <T> T createValid(@NonNull Class<T> beanType, Object ... arguments) throws ConstraintViolationException {
        ArgumentUtils.requireNonNull((String)"type", beanType);
        BeanIntrospection<T> introspection = this.getBeanIntrospection(beanType);
        if (introspection == null) {
            throw new ValidationException("Passed bean type [" + beanType + "] cannot be introspected. Please annotate with @Introspected");
        }
        Set<ConstraintViolation<T>> constraintViolations = this.validateConstructorParameters(introspection, arguments, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        Object instance = introspection.instantiate(arguments);
        Set<ConstraintViolation<Object>> errors = this.validate(introspection, instance, new Class[0]);
        if (errors.isEmpty()) {
            return (T)instance;
        }
        throw new ConstraintViolationException(errors);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.beanIntrospector.findIntrospection(clazz).map(IntrospectedBeanDescriptor::new).orElseGet(() -> new EmptyDescriptor(clazz));
    }

    public <T> T unwrap(Class<T> type) {
        throw new UnsupportedOperationException("Validator unwrapping not supported by this implementation");
    }

    @Override
    @NonNull
    public ExecutableMethodValidator forExecutables() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull ExecutableMethod method, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"parameterValues", (Object)parameterValues);
        ArgumentUtils.requireNonNull((String)"object", object);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        Argument[] arguments = method.getArguments();
        int argLen = arguments.length;
        if (argLen != parameterValues.length) {
            throw new IllegalArgumentException("The method parameter array must have exactly " + argLen + " elements.");
        }
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(object, parameterValues, groups);
        context.addMethodNode((MethodReference<?, ?>)method);
        try {
            this.validateParametersInternal(context, object, parameterValues, arguments, argLen);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(context.overallViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull ExecutableMethod method, @NonNull Collection<MutableArgumentValue<?>> argumentValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"object", object);
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        ArgumentUtils.requireNonNull((String)"parameterValues", argumentValues);
        Argument[] arguments = method.getArguments();
        int argLen = arguments.length;
        if (argLen != argumentValues.size()) {
            throw new IllegalArgumentException("The method parameter array must have exactly " + argLen + " elements.");
        }
        Object[] parameters = argumentValues.stream().map(ArgumentValue::getValue).toArray();
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(object, parameters, groups);
        context.addMethodNode((MethodReference<?, ?>)method);
        try {
            this.validateParametersInternal(context, object, parameters, arguments, argLen);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(context.overallViolations);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateParameters(@NonNull T object, @NonNull Method method, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        return this.executionHandleLocator.findExecutableMethod(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes()).map(executableMethod -> this.validateParameters(object, (ExecutableMethod)executableMethod, parameterValues, groups)).orElse(Collections.emptySet());
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T object, @NonNull Method method, @Nullable Object returnValue, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"method", (Object)method);
        ArgumentUtils.requireNonNull((String)"object", object);
        return this.executionHandleLocator.findExecutableMethod(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes()).map(executableMethod -> this.validateReturnValue(object, (ExecutableMethod<?, Object>)executableMethod, returnValue, groups)).orElse(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateReturnValue(@NonNull T object, @NonNull ExecutableMethod<?, Object> executableMethod, @Nullable Object returnValue, Class<?> ... groups) {
        ReturnType returnType = executableMethod.getReturnType();
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(object, groups);
        boolean hasValid = executableMethod.hasStereotype(Valid.class);
        boolean hasConstraint = executableMethod.hasStereotype(Constraint.class);
        context.addMethodNode((MethodReference<?, ?>)executableMethod);
        context.addReturnValueNode();
        try {
            this.visitElement(context, object, returnType.asArgument(), returnValue, hasValid, hasConstraint);
        }
        finally {
            context.removeLast();
            context.removeLast();
        }
        return context.overallViolations;
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull Constructor<? extends T> constructor, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"constructor", constructor);
        Class<? extends T> declaringClass = constructor.getDeclaringClass();
        BeanIntrospection<? extends T> introspection = this.getBeanIntrospection(declaringClass);
        return this.validateConstructorParameters(introspection, parameterValues, new Class[0]);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(@NonNull BeanIntrospection<? extends T> introspection, @NonNull Object[] parameterValues, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"introspection", introspection);
        Class beanType = introspection.getBeanType();
        Argument[] constructorArguments = introspection.getConstructorArguments();
        return this.validateConstructorParameters(beanType, constructorArguments, parameterValues, groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<ConstraintViolation<T>> validateConstructorParameters(Class<? extends T> beanType, Argument<?>[] constructorArguments, @NonNull Object[] parameterValues, @Nullable Class<?>[] groups) {
        int argLength;
        if ((parameterValues = parameterValues != null ? parameterValues : ArrayUtils.EMPTY_OBJECT_ARRAY).length != (argLength = constructorArguments.length)) {
            throw new IllegalArgumentException("Expected exactly [" + argLength + "] constructor arguments");
        }
        DefaultConstraintValidatorContext<Class<T>> context = new DefaultConstraintValidatorContext<Class<T>>(beanType, constructorArguments, groups);
        context.addConstructorNode(beanType.getSimpleName(), constructorArguments);
        try {
            this.validateParametersInternal(context, null, parameterValues, constructorArguments, argLength);
        }
        finally {
            context.removeLast();
        }
        return Collections.unmodifiableSet(context.overallViolations);
    }

    @Override
    @NonNull
    public <T> Set<ConstraintViolation<T>> validateConstructorReturnValue(@NonNull Constructor<? extends T> constructor, @NonNull T createdObject, Class<?> ... groups) {
        return this.validate(createdObject, groups);
    }

    @Override
    @NonNull
    public <T> Publisher<T> validatePublisher(@NonNull ReturnType<?> returnType, @NonNull Publisher<T> publisher, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"publisher", publisher);
        ArgumentUtils.requireNonNull((String)"returnType", returnType);
        if (returnType.getTypeParameters().length == 0) {
            return publisher;
        }
        Argument typeParameter = returnType.getTypeParameters()[0];
        Argument publisherArgument = Argument.of(publisher.getClass());
        Object output = Publishers.isSingle((Class)returnType.getType()) ? Mono.from(publisher).flatMap(value -> {
            Set<ConstraintViolation<?>> violations = this.validatePublisherValue(publisherArgument, publisher, groups, typeParameter, value);
            return violations.isEmpty() ? Mono.just((Object)value) : Mono.error((Throwable)new ConstraintViolationException(violations));
        }) : Flux.from(publisher).flatMap(value -> {
            Set<ConstraintViolation<?>> violations = this.validatePublisherValue(publisherArgument, publisher, groups, typeParameter, value);
            return violations.isEmpty() ? Flux.just((Object)value) : Flux.error((Throwable)new ConstraintViolationException(violations));
        });
        Class returnClass = returnType.getType();
        if (!Publisher.class.isAssignableFrom(returnClass)) {
            return output;
        }
        return (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)output, (Class)returnClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E> Set<? extends ConstraintViolation<?>> validatePublisherValue(Argument<T> publisherArgument, @NonNull T publisher, Class<?>[] groups, Argument<E> valueArgument, E value) {
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(publisher, groups);
        context.addReturnValueNode();
        try {
            this.validateIterableValue(context, publisher, "<publisher element>", publisherArgument, valueArgument, value, null, null, 0, true, publisherArgument.getAnnotationMetadata().hasAnnotation(Valid.class) || valueArgument.getAnnotationMetadata().hasAnnotation(Valid.class), valueArgument.getAnnotationMetadata().hasAnnotation(Constraint.class));
        }
        finally {
            context.removeLast();
        }
        return context.overallViolations;
    }

    @Override
    @NonNull
    public <T> CompletionStage<T> validateCompletionStage(@NonNull CompletionStage<T> completionStage, @NonNull Argument<T> argument, Class<?> ... groups) {
        ArgumentUtils.requireNonNull((String)"completionStage", completionStage);
        return completionStage.thenApply(value -> {
            DefaultConstraintValidatorContext<Object> newContext = new DefaultConstraintValidatorContext<Object>(null, Object.class, groups);
            newContext.addContainerElementNode("<completion stage element>", CompletionStage.class, null, null, false, 0);
            try {
                this.visitElement(newContext, newContext.getRootBean(), argument, value);
            }
            finally {
                newContext.removeLast();
            }
            if (!newContext.overallViolations.isEmpty()) {
                throw new ConstraintViolationException(newContext.overallViolations);
            }
            return value;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void validateBeanArgument(@NonNull BeanResolutionContext resolutionContext, @NonNull InjectionPoint injectionPoint, @NonNull Argument<T> argument, int index, @Nullable T value) throws BeanInstantiationException {
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        boolean hasValid = annotationMetadata.hasStereotype(Valid.class);
        boolean hasConstraint = annotationMetadata.hasStereotype(Constraint.class);
        if (!hasConstraint && !hasValid) {
            return;
        }
        DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(value, new Class[0]);
        Class rootClass = injectionPoint.getDeclaringBean().getBeanType();
        context.addConstructorNode(rootClass.getName(), injectionPoint.getDeclaringBean().getConstructor().getArguments());
        context.addPropertyNode(argument.getName());
        try {
            this.visitElement(context, null, argument, value);
        }
        finally {
            context.removeLast();
        }
        this.failOnError(resolutionContext, context.overallViolations, rootClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void validateBean(@NonNull BeanResolutionContext resolutionContext, @NonNull BeanDefinition<T> definition, @NonNull T bean) throws BeanInstantiationException {
        Class beanType;
        if (definition instanceof ProxyBeanDefinition) {
            ProxyBeanDefinition proxyBeanDefinition = (ProxyBeanDefinition)definition;
            beanType = proxyBeanDefinition.getTargetType();
        } else {
            beanType = definition.getBeanType();
        }
        BeanIntrospection<T> introspection = this.getBeanIntrospection(bean, beanType);
        if (introspection != null) {
            Set<ConstraintViolation<T>> errors = this.validate(introspection, bean, new Class[0]);
            this.failOnError(resolutionContext, errors, beanType);
        } else if (bean instanceof Intercepted && definition.hasStereotype(ConfigurationReader.class)) {
            Collection executableMethods = definition.getExecutableMethods();
            if (CollectionUtils.isEmpty((Collection)executableMethods)) {
                return;
            }
            DefaultConstraintValidatorContext<T> context = new DefaultConstraintValidatorContext<T>(bean, new Class[0]);
            Object[] interfaces = beanType.getInterfaces();
            if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
                context.addConstructorNode(((Class)interfaces[0]).getSimpleName(), new Argument[0]);
            } else {
                context.addConstructorNode(beanType.getSimpleName(), new Argument[0]);
            }
            for (ExecutableMethod executableMethod : executableMethods) {
                if (!executableMethod.hasAnnotation(Property.class)) continue;
                boolean hasConstraint = executableMethod.hasStereotype(Constraint.class);
                boolean isValid = executableMethod.hasStereotype(Valid.class);
                if (!hasConstraint && !isValid) continue;
                Object value = executableMethod.invoke(bean, new Object[0]);
                ReturnType returnType = executableMethod.getReturnType();
                context.addPropertyNode(executableMethod.getName());
                try {
                    this.visitElement(context, bean, returnType.asArgument(), value);
                }
                finally {
                    context.removeLast();
                }
            }
            this.failOnError(resolutionContext, context.overallViolations, beanType);
        } else {
            throw new BeanInstantiationException(resolutionContext, "Cannot validate bean [" + beanType.getName() + "]. No bean introspection present. Please add @Introspected.");
        }
    }

    @Nullable
    protected <T> BeanIntrospection<T> getBeanIntrospection(@NonNull T object, @NonNull Class<T> definedClass) {
        if (object == null) {
            return null;
        }
        return this.beanIntrospector.findIntrospection(object.getClass()).orElseGet(() -> this.beanIntrospector.findIntrospection(definedClass).orElse(null));
    }

    @Nullable
    protected <T> BeanIntrospection<T> getBeanIntrospection(@NonNull T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Class) {
            return this.getBeanIntrospection((Class)object);
        }
        return this.beanIntrospector.findIntrospection(object.getClass()).orElse(null);
    }

    @Nullable
    protected <T> BeanIntrospection<T> getBeanIntrospection(@NonNull Class<T> type) {
        return this.beanIntrospector.findIntrospection(type).orElse(null);
    }

    private <R, E> void instrumentPublisherArgumentWithValidation(@NonNull DefaultConstraintValidatorContext<R> context, @NonNull Object[] argumentValues, int argumentIndex, @NonNull Argument<E> publisherArgument, E parameterValue) {
        Publisher publisher = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, parameterValue, Publisher.class);
        DefaultConstraintValidatorContext valueContext = context.copy();
        Object objectPublisher = publisherArgument.isSpecifiedSingle() ? Mono.from((Publisher)publisher).flatMap(value -> {
            this.validatePublishedValue(valueContext, argumentIndex, publisherArgument, parameterValue, value);
            return valueContext.overallViolations.isEmpty() ? Mono.just((Object)value) : Mono.error((Throwable)new ConstraintViolationException(valueContext.overallViolations));
        }) : Flux.from((Publisher)publisher).flatMap(value -> {
            this.validatePublishedValue(valueContext, argumentIndex, publisherArgument, parameterValue, value);
            return valueContext.overallViolations.isEmpty() ? Flux.just((Object)value) : Flux.error((Throwable)new ConstraintViolationException(valueContext.overallViolations));
        });
        argumentValues[argumentIndex] = Publishers.convertPublisher((ConversionService)this.conversionService, (Object)objectPublisher, (Class)publisherArgument.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, E> void validatePublishedValue(@NonNull DefaultConstraintValidatorContext<R> context, int argumentIndex, @NonNull Argument<E> publisherArgument, E value, @NonNull Object publisherInstance) {
        Argument[] typeParameters = publisherArgument.getTypeParameters();
        if (typeParameters.length == 0) {
            return;
        }
        Argument valueArgument = typeParameters[0];
        context.addParameterNode(publisherArgument.getName(), argumentIndex);
        context.addContainerElementNode("<publisher element>", value.getClass(), null, null, true, 0);
        try {
            this.visitElement(context, context.getRootBean(), valueArgument, publisherInstance);
        }
        finally {
            context.removeLast();
        }
    }

    private <T, E> void instrumentCompletionStageArgumentWithValidation(@NonNull DefaultConstraintValidatorContext<T> context, @NonNull Object[] argumentValues, int argumentIndex, @NonNull Argument<E> completionStageArgument, E parameterValue) {
        CompletionStage<Object> validatedStage;
        CompletionStage completionStage = (CompletionStage)parameterValue;
        argumentValues[argumentIndex] = validatedStage = completionStage.thenApply(value -> {
            DefaultConstraintValidatorContext newContext = context.copy();
            Argument[] typeParameters = completionStageArgument.getTypeParameters();
            if (typeParameters.length == 0) {
                return value;
            }
            Argument valueArgument = typeParameters[0];
            newContext.addParameterNode(completionStageArgument.getName(), argumentIndex);
            newContext.addContainerElementNode("<completion stage element>", parameterValue.getClass(), null, null, true, 0);
            try {
                this.visitElement(newContext, newContext.getRootBean(), valueArgument, value);
            }
            finally {
                newContext.removeLast();
            }
            if (!newContext.overallViolations.isEmpty()) {
                throw new ConstraintViolationException(newContext.overallViolations);
            }
            return value;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void validateParametersInternal(@NonNull DefaultConstraintValidatorContext<T> context, @Nullable T bean, @NonNull Object[] parameters, @NonNull Argument<?>[] arguments, int argLen) {
        for (int parameterIndex = 0; parameterIndex < argLen; ++parameterIndex) {
            boolean isCompletionStage;
            boolean isPublisher;
            Argument<?> argument = arguments[parameterIndex];
            if (!argument.getAnnotationMetadata().hasAnnotation(ValidatedElement.class)) continue;
            Class parameterType = argument.getType();
            Object parameterValue = parameters[parameterIndex];
            boolean hasValue = parameterValue != null;
            boolean bl = isPublisher = hasValue && Publishers.isConvertibleToPublisher((Class)parameterType);
            if (isPublisher) {
                this.instrumentPublisherArgumentWithValidation(context, parameters, parameterIndex, argument, parameterValue);
                continue;
            }
            boolean bl2 = isCompletionStage = hasValue && CompletionStage.class.isAssignableFrom(parameterType);
            if (isCompletionStage) {
                this.instrumentCompletionStageArgumentWithValidation(context, parameters, parameterIndex, argument, parameterValue);
                continue;
            }
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            context.addParameterNode(argument.getName(), parameterIndex);
            try {
                this.visitElement(context, bean, argument, parameterValue, annotationMetadata.hasStereotype(Valid.class), annotationMetadata.hasStereotype(Constraint.class));
                continue;
            }
            finally {
                context.removeLast();
            }
        }
    }

    private <R, T> void doValidate(@NonNull DefaultConstraintValidatorContext<R> context, @NonNull BeanIntrospection<T> introspection, @NonNull T object) {
        this.visitElement(context, object, Argument.of((Class)introspection.getBeanType(), (AnnotationMetadata)introspection.getAnnotationMetadata(), (Argument[])new Argument[0]), object);
        for (BeanProperty property : introspection.getBeanProperties()) {
            this.visitProperty(context, object, property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T> void visitProperty(DefaultConstraintValidatorContext<R> context, T object, BeanProperty<T, Object> property) {
        if (property.isWriteOnly()) {
            return;
        }
        context.addPropertyNode(property.getName());
        try {
            this.visitElement(context, object, property.asArgument(), property.get(object));
        }
        finally {
            context.removeLast();
        }
    }

    private <R> boolean canCascade(@NonNull DefaultConstraintValidatorContext<R> context, Object propertyValue) {
        boolean isReachable = this.traversableResolver.isReachable(propertyValue, context.currentPath.nodes.peekLast(), context.getRootClass(), (Path)context.currentPath, ElementType.FIELD);
        if (!isReachable) {
            return false;
        }
        return this.traversableResolver.isCascadable(propertyValue, context.currentPath.nodes.peekLast(), context.getRootClass(), (Path)context.currentPath, ElementType.FIELD);
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object bean, Argument<E> annotatedElementType, E elementValue) {
        this.visitElement(context, bean, annotatedElementType, elementValue, annotatedElementType.getAnnotationMetadata().hasStereotype(Valid.class), annotatedElementType.getAnnotationMetadata().hasStereotype(Constraint.class));
    }

    private <R, E> void visitElement(DefaultConstraintValidatorContext<R> context, Object leftBean, Argument<E> elementArgument, E elementValue, boolean hasValid, boolean hasConstraint) {
        boolean iterableValidated = this.visitIterable(context, leftBean, elementArgument, elementValue);
        if (hasConstraint) {
            this.validateConstrains(context, leftBean, elementArgument, elementValue);
        }
        if (hasValid && !iterableValidated) {
            this.propagateValidation(context, leftBean, elementArgument, elementValue);
        }
    }

    private <R, E> void propagateValidation(DefaultConstraintValidatorContext<R> context, Object leftBean, Argument<E> elementType, E elementValue) {
        if (elementValue == null || context.validatedObjects.contains(elementValue)) {
            return;
        }
        BeanIntrospection<E> beanIntrospection = this.getBeanIntrospection(elementValue, elementType.getType());
        if (beanIntrospection == null) {
            DefaultConstraintViolation<R> violation = this.createIntrospectionConstraintViolation(context, leftBean, elementType, elementValue);
            context.overallViolations.add(violation);
            return;
        }
        if (this.canCascade(context, elementValue)) {
            context.validatedObjects.add(elementValue);
            this.doValidate(context, beanIntrospection, elementValue);
        }
    }

    private <R, I> boolean visitIterable(final DefaultConstraintValidatorContext<R> context, final Object leftBean, final Argument<I> iterableArgument, I iterable) {
        boolean valueHasConstraint;
        boolean valueHasValid;
        boolean keyHasValid;
        boolean keyHasConstraint;
        Optional opt = this.valueExtractorRegistry.findValueExtractor(iterableArgument.getType());
        if (opt.isEmpty()) {
            return false;
        }
        if (iterable == null) {
            return true;
        }
        final Argument[] arguments = iterableArgument.getTypeParameters();
        boolean iterableIsValid = iterableArgument.getAnnotationMetadata().hasStereotype(Valid.class);
        if (arguments.length == 1) {
            keyHasConstraint = false;
            keyHasValid = false;
            valueHasValid = iterableIsValid || arguments[0].getAnnotationMetadata().hasStereotype(Valid.class);
            valueHasConstraint = arguments[0].getAnnotationMetadata().hasStereotype(Constraint.class);
        } else if (arguments.length == 2) {
            keyHasValid = iterableIsValid || arguments[0].getAnnotationMetadata().hasStereotype(Valid.class);
            keyHasConstraint = arguments[0].getAnnotationMetadata().hasStereotype(Constraint.class);
            valueHasValid = iterableIsValid || arguments[1].getAnnotationMetadata().hasStereotype(Valid.class);
            valueHasConstraint = arguments[1].getAnnotationMetadata().hasStereotype(Constraint.class);
        } else {
            keyHasConstraint = false;
            keyHasValid = false;
            valueHasConstraint = iterableArgument.getAnnotationMetadata().hasStereotype(Constraint.class);
            valueHasValid = iterableIsValid;
        }
        opt.get().extractValues(iterable, new ValueExtractor.ValueReceiver(){

            public void value(String nodeName, Object value) {
                Argument<Object> argument = this.asArgument(value);
                DefaultValidator.this.validateIterableValue(context, leftBean, nodeName, iterableArgument, argument, value, null, null, 0, false, valueHasValid, valueHasConstraint);
            }

            public void iterableValue(String nodeName, Object iterableValue) {
                Argument<Object> argument = this.asArgument(iterableValue);
                DefaultValidator.this.validateIterableValue(context, leftBean, nodeName, iterableArgument, argument, iterableValue, null, null, 0, true, valueHasValid, valueHasConstraint);
            }

            public void indexedValue(String nodeName, int i, Object iterableValue) {
                Argument<Object> argument = this.asArgument(iterableValue);
                DefaultValidator.this.validateIterableValue(context, leftBean, nodeName, iterableArgument, argument, iterableValue, i, null, 0, true, valueHasValid, valueHasConstraint);
            }

            public void keyedValue(String nodeName, Object key, Object keyedValue) {
                Argument<Object> argumentKey = this.asArgument(iterableArgument);
                DefaultValidator.this.validateIterableValue(context, leftBean, "<map key>", iterableArgument, argumentKey, key, null, key, 0, true, keyHasValid, keyHasConstraint);
                Argument<Object> argumentValue = this.asArgument(iterableArgument, 1);
                DefaultValidator.this.validateIterableValue(context, leftBean, "<map value>", iterableArgument, argumentValue, keyedValue, null, key, 1, true, valueHasValid, valueHasConstraint);
            }

            private Argument<Object> asArgument(Object value) {
                return this.asArgument(value, 0);
            }

            private Argument<Object> asArgument(Object value, int index) {
                Argument argument = arguments.length == 0 ? Argument.of(value == null ? Object.class : value.getClass(), (AnnotationMetadata)iterableArgument.getAnnotationMetadata(), (Argument[])new Argument[0]) : arguments[index];
                return argument;
            }
        });
        return true;
    }

    private <R, I, E> void validateIterableValue(DefaultConstraintValidatorContext<R> context, Object leftBean, String name, Argument<I> iterableArgument, Argument<E> valueArgument, E value, Integer index, Object key, Integer typeArgumentIndex, boolean isInIterable, boolean hasValid, boolean hasConstraint) {
        if (isInIterable) {
            context.addContainerElementNode(name, iterableArgument.getType(), index, key, isInIterable, typeArgumentIndex);
        }
        this.visitElement(context, leftBean, valueArgument, value, hasValid, hasConstraint);
        if (isInIterable) {
            context.removeLast();
        }
    }

    private <R, E> void validateConstrains(DefaultConstraintValidatorContext<R> context, @Nullable Object leftBean, @NonNull Argument<E> elementArgument, @Nullable E elementValue) {
        for (Class constraintType : elementArgument.getAnnotationMetadata().getAnnotationTypesByStereotype(Constraint.class)) {
            this.valueConstraintOnElement(context, leftBean, elementArgument, elementValue, constraintType);
        }
    }

    private <R, E, A extends Annotation> void valueConstraintOnElement(DefaultConstraintValidatorContext<R> context, @Nullable Object leafBean, Argument<E> elementArgument, @Nullable E elementValue, Class<A> constraintType) {
        boolean isDefaultGroup = context.groups == DEFAULT_GROUPS || context.groups.contains(Default.class);
        List annotationConstraints = elementArgument.getAnnotationMetadata().getAnnotationValuesByType(constraintType);
        LinkedHashSet constraints = CollectionUtils.newLinkedHashSet((int)annotationConstraints.size());
        for (AnnotationValue annotationValue : annotationConstraints) {
            Object[] classValues = annotationValue.classValues("groups");
            if (isDefaultGroup && ArrayUtils.isEmpty((Object[])classValues)) {
                constraints.add(annotationValue);
                continue;
            }
            List<Object> constraintGroups = Arrays.asList(classValues);
            if (!context.groups.stream().anyMatch(constraintGroups::contains)) continue;
            constraints.add(annotationValue);
        }
        this.validateConstraint(context, leafBean, elementArgument.getAnnotationMetadata(), elementValue, constraintType, constraints, elementArgument.getType());
    }

    private <R, E, A extends Annotation> void validateConstraint(DefaultConstraintValidatorContext<R> context, Object leafBean, AnnotationMetadata annotationMetadata, E elementValue, Class<A> constraintType, Set<AnnotationValue<A>> constraints, Class<E> type) {
        ConstraintValidator validator = this.constraintValidatorRegistry.findConstraintValidator(constraintType, type).orElse(null);
        if (validator == null) {
            return;
        }
        for (AnnotationValue<A> annotationValue : constraints) {
            if (validator.isValid(elementValue, annotationValue, context)) continue;
            String messageTemplate = this.buildMessageTemplate(context, annotationValue, annotationMetadata);
            Map<String, Object> variables = this.newConstraintVariables(annotationValue, elementValue, annotationMetadata);
            String message = this.messageSource.interpolate(messageTemplate, MessageSource.MessageContext.of(variables));
            DefaultConstraintDescriptor<A> constraintDescriptor = new DefaultConstraintDescriptor<A>(annotationMetadata, constraintType, annotationValue);
            DefaultConstraintViolation<R> constraintViolation = new DefaultConstraintViolation<R>(context.getRootBean(), context.getRootClass(), leafBean, elementValue, message, messageTemplate, new PathImpl(context.currentPath), constraintDescriptor, context.executableParameterValues);
            context.overallViolations.add(constraintViolation);
            context.messageTemplate(null);
        }
    }

    private <A extends Annotation> Map<String, Object> newConstraintVariables(AnnotationValue<A> annotationValue, @Nullable Object propertyValue, AnnotationMetadata annotationMetadata) {
        Map values = annotationValue.getValues();
        LinkedHashMap variables = CollectionUtils.newLinkedHashMap((int)values.size());
        for (Map.Entry entry : values.entrySet()) {
            variables.put(entry.getKey().toString(), entry.getValue());
        }
        variables.put("validatedValue", propertyValue);
        Map defaultValues = annotationMetadata.getDefaultValues(annotationValue.getAnnotationName());
        for (Map.Entry entry : defaultValues.entrySet()) {
            Object v;
            String n = ((CharSequence)entry.getKey()).toString();
            if (variables.containsKey(n) || (v = entry.getValue()) == null) continue;
            variables.put(n, v);
        }
        return variables;
    }

    private <R> String buildMessageTemplate(DefaultConstraintValidatorContext<R> context, AnnotationValue<?> annotationValue, AnnotationMetadata annotationMetadata) {
        return context.getMessageTemplate().orElseGet(() -> annotationValue.stringValue("message").orElseGet(() -> (String)((Object)annotationMetadata.getDefaultValue(annotationValue.getAnnotationName(), "message", String.class).orElse("{" + annotationValue.getAnnotationName() + ".message}"))));
    }

    private <T> void failOnError(@NonNull BeanResolutionContext resolutionContext, Set<ConstraintViolation<T>> errors, Class<?> beanType) {
        if (!errors.isEmpty()) {
            StringBuilder builder = new StringBuilder().append("Validation failed for bean definition [").append(beanType.getName()).append("]\nList of constraint violations:[\n");
            for (ConstraintViolation<T> violation : errors) {
                builder.append('\t').append(violation.getPropertyPath()).append(" - ").append(violation.getMessage()).append('\n');
            }
            builder.append(']');
            throw new BeanInstantiationException(resolutionContext, builder.toString());
        }
    }

    @NonNull
    private <R, T, E> DefaultConstraintViolation<R> createIntrospectionConstraintViolation(DefaultConstraintValidatorContext<R> context, T leftBean, Argument<E> invalidValueType, E invalidValue) {
        String messageTemplate = context.getMessageTemplate().orElseGet(() -> "{" + Introspected.class.getName() + ".message}");
        return new DefaultConstraintViolation<R>(context.getRootBean(), context.getRootClass(), leftBean, invalidValue, this.messageSource.interpolate(messageTemplate, MessageSource.MessageContext.of(Collections.singletonMap("type", invalidValueType.getType().getName()))), messageTemplate, new PathImpl(context.currentPath), null, context.executableParameterValues);
    }

    /*
     * Exception decompiling
     */
    private List<Class<?>[]> findGroupSequences(Class<?>[] groups) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final class DefaultConstraintValidatorContext<R>
    implements ConstraintValidatorContext {
        private final R rootBean;
        @Nullable
        private final Class<R> rootClass;
        @Nullable
        private final Object[] executableParameterValues;
        private final Set<Object> validatedObjects = new HashSet<Object>(20);
        private final PathImpl currentPath;
        private final List<Class<?>> groups;
        private String messageTemplate = null;
        private final Set<ConstraintViolation<R>> overallViolations;

        private DefaultConstraintValidatorContext(R rootBean, Class<R> rootClass, Class<?> ... groups) {
            this(rootBean, rootClass, null, new PathImpl(), new LinkedHashSet<ConstraintViolation<R>>(), groups);
        }

        private DefaultConstraintValidatorContext(R rootBean, Class<?> ... groups) {
            this(rootBean, rootBean.getClass(), null, new PathImpl(), new LinkedHashSet<ConstraintViolation<R>>(), groups);
        }

        private DefaultConstraintValidatorContext(R rootBean, Object[] executableParameterValues, Class<?> ... groups) {
            this(rootBean, rootBean.getClass(), executableParameterValues, new PathImpl(), new LinkedHashSet<ConstraintViolation<R>>(), groups);
        }

        private DefaultConstraintValidatorContext(R rootBean, Class<R> rootClass, Object[] executableParameterValues, PathImpl path, Set<ConstraintViolation<R>> overallViolations, Class<?> ... groups) {
            this.rootBean = rootBean;
            this.rootClass = rootClass;
            this.executableParameterValues = executableParameterValues;
            if (ArrayUtils.isNotEmpty((Object[])groups)) {
                this.sanityCheckGroups(groups);
                ArrayList groupList = new ArrayList();
                for (Class<?> group : groups) {
                    this.addInheritedGroups(group, groupList);
                }
                this.groups = Collections.unmodifiableList(groupList);
            } else {
                this.groups = DEFAULT_GROUPS;
            }
            this.currentPath = path != null ? path : new PathImpl();
            this.overallViolations = overallViolations;
        }

        private DefaultConstraintValidatorContext(Class<R> rootClass, Class<?> ... groups) {
            this((null), (Class<Object>)rootClass, groups);
        }

        private void sanityCheckGroups(Class<?>[] groups) {
            ArgumentUtils.requireNonNull((String)"groups", groups);
            for (Class<?> clazz : groups) {
                if (clazz == null) {
                    throw new IllegalArgumentException("Validation groups must be non-null");
                }
                if (clazz.isInterface()) continue;
                throw new IllegalArgumentException("Validation groups must be interfaces. " + clazz.getName() + " is not.");
            }
        }

        @Nullable
        public R getRootBean() {
            return this.rootBean;
        }

        public Class<R> getRootClass() {
            return this.rootClass;
        }

        private void addInheritedGroups(Class<?> group, List<Class<?>> groups) {
            if (!groups.contains(group)) {
                groups.add(group);
            }
            for (Class<?> inheritedGroup : group.getInterfaces()) {
                this.addInheritedGroups(inheritedGroup, groups);
            }
        }

        @Override
        @NonNull
        public ClockProvider getClockProvider() {
            return DefaultValidator.this.clockProvider;
        }

        @Override
        public void messageTemplate(@Nullable String messageTemplate) {
            this.messageTemplate = messageTemplate;
        }

        Optional<String> getMessageTemplate() {
            return Optional.ofNullable(this.messageTemplate);
        }

        Path.Node addPropertyNode(String name) {
            DefaultPropertyNode node = new DefaultPropertyNode(name);
            this.currentPath.nodes.add(node);
            return node;
        }

        Path.Node addParameterNode(String name, int index) {
            DefaultParameterNode node = new DefaultParameterNode(name, index);
            this.currentPath.nodes.add(node);
            return node;
        }

        Path.Node addReturnValueNode() {
            DefaultReturnValueNode returnValueNode = new DefaultReturnValueNode("<return value>");
            this.currentPath.nodes.add(returnValueNode);
            return returnValueNode;
        }

        Path.Node addContainerElementNode(String name, Class<?> containerClass, Integer index, Object key, boolean isInIterable, Integer typeArgumentIndex) {
            DefaultContainerElementNode node = new DefaultContainerElementNode(name, containerClass, index, key, isInIterable, typeArgumentIndex);
            this.currentPath.nodes.add(node);
            return node;
        }

        void removeLast() {
            this.currentPath.nodes.removeLast();
        }

        Path.Node addMethodNode(MethodReference<?, ?> reference) {
            DefaultMethodNode methodNode = new DefaultMethodNode(reference);
            this.currentPath.nodes.add(methodNode);
            return methodNode;
        }

        Path.Node addConstructorNode(final String simpleName, final Argument<?> ... constructorArguments) {
            DefaultConstructorNode node = new DefaultConstructorNode(new MethodReference<Object, Object>(){

                public Argument[] getArguments() {
                    return constructorArguments;
                }

                public Method getTargetMethod() {
                    return null;
                }

                public ReturnType<Object> getReturnType() {
                    return null;
                }

                public Class getDeclaringType() {
                    return null;
                }

                public String getMethodName() {
                    return simpleName;
                }
            });
            this.currentPath.nodes.add(node);
            return node;
        }

        DefaultConstraintValidatorContext<R> copy() {
            return new DefaultConstraintValidatorContext<R>(this.rootBean, this.rootClass, this.executableParameterValues, new PathImpl(this.currentPath), new LinkedHashSet<ConstraintViolation<R>>(this.overallViolations), new Class[0]);
        }
    }

    private static final class PathImpl
    implements Path {
        final Deque<Path.Node> nodes;

        private PathImpl(PathImpl nodes) {
            this.nodes = new LinkedList<Path.Node>(nodes.nodes);
        }

        private PathImpl() {
            this.nodes = new LinkedList<Path.Node>();
        }

        public Iterator<Path.Node> iterator() {
            return this.nodes.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator<Path.Node> i = this.nodes.iterator();
            boolean firstNode = true;
            while (i.hasNext()) {
                Path.Node node = i.next();
                if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
                    if (node.isInIterable()) {
                        builder.append('[');
                        if (node.getIndex() != null) {
                            builder.append(node.getIndex());
                        } else if (node.getKey() != null) {
                            builder.append(node.getKey());
                        }
                        builder.append(']');
                    }
                    builder.append(node.getName());
                } else {
                    builder.append(firstNode ? "" : ".");
                    builder.append(node.getName());
                }
                firstNode = false;
            }
            return builder.toString();
        }
    }

    private record DefaultConstraintViolation<T>(@Nullable T rootBean, @Nullable Class<T> rootBeanClass, Object leafBean, Object invalidValue, String message, String messageTemplate, Path path, ConstraintDescriptor<?> constraintDescriptor, @Nullable Object[] executableParameterValues) implements ConstraintViolation<T>
    {
        public String getMessage() {
            return this.message;
        }

        public String getMessageTemplate() {
            return this.messageTemplate;
        }

        public T getRootBean() {
            return this.rootBean;
        }

        public Class<T> getRootBeanClass() {
            return this.rootBeanClass;
        }

        public Object getLeafBean() {
            return this.leafBean;
        }

        public Object[] getExecutableParameters() {
            return Objects.requireNonNullElse(this.executableParameterValues, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }

        public Object getExecutableReturnValue() {
            return null;
        }

        public Path getPropertyPath() {
            return this.path;
        }

        public Object getInvalidValue() {
            return this.invalidValue;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.constraintDescriptor;
        }

        public <U> U unwrap(Class<U> type) {
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }

        @Override
        public String toString() {
            return "DefaultConstraintViolation{rootBean=" + this.rootBeanClass + ", invalidValue=" + this.invalidValue + ", path=" + this.path + "}";
        }
    }

    private record EmptyDescriptor(Class<?> elementClass) implements BeanDescriptor,
    ElementDescriptor.ConstraintFinder
    {
        public boolean isBeanConstrained() {
            return false;
        }

        public PropertyDescriptor getConstraintsForProperty(String propertyName) {
            return null;
        }

        public Set<PropertyDescriptor> getConstrainedProperties() {
            return Collections.emptySet();
        }

        public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
            return null;
        }

        public Set<MethodDescriptor> getConstrainedMethods(MethodType methodType, MethodType ... methodTypes) {
            return Collections.emptySet();
        }

        public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
            return null;
        }

        public Set<ConstructorDescriptor> getConstrainedConstructors() {
            return Collections.emptySet();
        }

        public boolean hasConstraints() {
            return false;
        }

        public Class<?> getElementClass() {
            return this.elementClass;
        }

        public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
            return this;
        }

        public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
            return this;
        }

        public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
            return Collections.emptySet();
        }

        public ElementDescriptor.ConstraintFinder findConstraints() {
            return this;
        }
    }

    private static final class DefaultContainerElementNode
    extends DefaultNode
    implements Path.ContainerElementNode {
        private final Class<?> containerClass;
        private final Integer index;
        private final Object key;
        private final boolean isInIterable;
        private final Integer typeArgumentIndex;

        public DefaultContainerElementNode(@Nullable String name, Class<?> containerClass, @Nullable Integer index, @Nullable Object key, boolean isInIterable, @Nullable Integer typeArgumentIndex) {
            super(name);
            this.containerClass = containerClass;
            this.index = index;
            this.key = key;
            this.isInIterable = isInIterable;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public Class<?> getContainerClass() {
            return this.containerClass;
        }

        public Integer getTypeArgumentIndex() {
            return this.typeArgumentIndex;
        }

        @Override
        public boolean isInIterable() {
            return this.isInIterable;
        }

        @Override
        public Integer getIndex() {
            return this.index;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        public ElementKind getKind() {
            return ElementKind.CONTAINER_ELEMENT;
        }
    }

    private static final class DefaultReturnValueNode
    extends DefaultNode
    implements Path.ReturnValueNode {
        public DefaultReturnValueNode(String name) {
            super(name);
        }

        public ElementKind getKind() {
            return ElementKind.RETURN_VALUE;
        }
    }

    private static final class DefaultParameterNode
    extends DefaultNode
    implements Path.ParameterNode {
        private final int parameterIndex;

        public DefaultParameterNode(@NonNull String name, int parameterIndex) {
            super(name);
            this.parameterIndex = parameterIndex;
        }

        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }
    }

    private static final class DefaultConstructorNode
    extends DefaultMethodNode
    implements Path.ConstructorNode {
        public DefaultConstructorNode(MethodReference<Object, Object> methodReference) {
            super(methodReference);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    private static class DefaultMethodNode
    extends DefaultNode
    implements Path.MethodNode {
        private final MethodReference<?, ?> methodReference;

        public DefaultMethodNode(MethodReference<?, ?> methodReference) {
            super(methodReference.getMethodName());
            this.methodReference = methodReference;
        }

        public List<Class<?>> getParameterTypes() {
            return Arrays.asList(this.methodReference.getArgumentTypes());
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }

    private static final class DefaultPropertyNode
    extends DefaultNode
    implements Path.PropertyNode {
        public DefaultPropertyNode(String name) {
            super(name);
        }

        public Class<?> getContainerClass() {
            return null;
        }

        public Integer getTypeArgumentIndex() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.PROPERTY;
        }
    }

    private static abstract class DefaultNode
    implements Path.Node {
        protected final String name;

        public DefaultNode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIterable() {
            return false;
        }

        public Integer getIndex() {
            return null;
        }

        public Object getKey() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        public <T extends Path.Node> T as(Class<T> nodeType) {
            if (nodeType.isInstance(this)) {
                return (T)((Path.Node)nodeType.cast(this));
            }
            throw new UnsupportedOperationException("Unwrapping is unsupported by this implementation");
        }
    }
}

