/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.validation.ConstraintViolationExceptionUtil;
import io.micronaut.validation.Validated;
import io.micronaut.validation.validator.ExecutableMethodValidator;
import io.micronaut.validation.validator.ReactiveValidator;
import io.micronaut.validation.validator.Validator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.util.Set;

@Singleton
public class ValidatingInterceptor
implements MethodInterceptor<Object, Object> {
    public static final int POSITION = InterceptPhase.VALIDATE.getPosition();
    @Nullable
    private final ExecutableValidator executableValidator;
    @Nullable
    private final ExecutableMethodValidator micronautValidator;
    private final ConversionService conversionService;
    private final boolean isPrependPropertyPath;

    public ValidatingInterceptor(@Nullable Validator micronautValidator, @Nullable ValidatorFactory validatorFactory, ConversionService conversionService, ValidatorConfiguration validatorConfiguration) {
        this.conversionService = conversionService;
        this.isPrependPropertyPath = validatorConfiguration.isPrependPropertyPath();
        if (validatorFactory != null) {
            jakarta.validation.Validator validator = validatorFactory.getValidator();
            if (validator instanceof Validator) {
                this.micronautValidator = (ExecutableMethodValidator)validator;
                this.executableValidator = null;
            } else {
                this.micronautValidator = null;
                this.executableValidator = validator.forExecutables();
            }
        } else if (micronautValidator != null) {
            this.micronautValidator = micronautValidator.forExecutables();
            this.executableValidator = null;
        } else {
            this.micronautValidator = null;
            this.executableValidator = null;
        }
    }

    public int getOrder() {
        return POSITION;
    }

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (this.executableValidator != null) {
            Set constraintViolations;
            Method targetMethod = context.getTargetMethod();
            if (targetMethod.getParameterTypes().length != 0 && !(constraintViolations = this.executableValidator.validateParameters(context.getTarget(), targetMethod, context.getParameterValues(), (Class[])this.getValidationGroups(context))).isEmpty()) {
                throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, constraintViolations);
            }
            return this.validateReturnExecutableValidator(context, targetMethod);
        }
        if (this.micronautValidator != null) {
            Set<ConstraintViolation<Object>> constraintViolations;
            ExecutableMethod executableMethod = context.getExecutableMethod();
            if (executableMethod.getArguments().length != 0 && !(constraintViolations = this.micronautValidator.validateParameters(context.getTarget(), executableMethod, context.getParameterValues(), this.getValidationGroups(context))).isEmpty()) {
                throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, constraintViolations);
            }
            ExecutableMethodValidator executableMethodValidator = this.micronautValidator;
            if (executableMethodValidator instanceof ReactiveValidator) {
                ReactiveValidator reactiveValidator = (ReactiveValidator)((Object)executableMethodValidator);
                InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
                try {
                    return switch (interceptedMethod.resultType()) {
                        case InterceptedMethod.ResultType.PUBLISHER -> interceptedMethod.handleResult(reactiveValidator.validatePublisher(context.getReturnType(), interceptedMethod.interceptResultAsPublisher(), this.getValidationGroups(context)));
                        case InterceptedMethod.ResultType.COMPLETION_STAGE -> interceptedMethod.handleResult(reactiveValidator.validateCompletionStage(interceptedMethod.interceptResultAsCompletionStage(), context.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT), this.getValidationGroups(context)));
                        case InterceptedMethod.ResultType.SYNCHRONOUS -> this.validateReturnMicronautValidator(context, (ExecutableMethod<Object, Object>)executableMethod);
                        default -> interceptedMethod.unsupported();
                    };
                }
                catch (Exception e) {
                    return interceptedMethod.handleException(e);
                }
            }
            return this.validateReturnMicronautValidator(context, (ExecutableMethod<Object, Object>)executableMethod);
        }
        return context.proceed();
    }

    private Object validateReturnMicronautValidator(MethodInvocationContext<Object, Object> context, ExecutableMethod<Object, Object> executableMethod) {
        Object result = context.proceed();
        Set<ConstraintViolation<Object>> constraintViolations = this.micronautValidator.validateReturnValue(context.getTarget(), executableMethod, result, this.getValidationGroups(context));
        if (!constraintViolations.isEmpty()) {
            throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, constraintViolations);
        }
        return result;
    }

    private Object validateReturnExecutableValidator(MethodInvocationContext<Object, Object> context, Method targetMethod) {
        Object result = context.proceed();
        Set constraintViolations = this.executableValidator.validateReturnValue(context.getTarget(), targetMethod, result, (Class[])this.getValidationGroups(context));
        if (!constraintViolations.isEmpty()) {
            throw ConstraintViolationExceptionUtil.createConstraintViolationException(this.isPrependPropertyPath, constraintViolations);
        }
        return result;
    }

    private Class<?>[] getValidationGroups(MethodInvocationContext<Object, Object> context) {
        return context.classValues(Validated.class, "groups");
    }
}

