/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.DefaultValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.DefaultConstraintValidators;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class DefaultAnnotatedElementValidator
extends DefaultValidator
implements AnnotatedElementValidator {
    public DefaultAnnotatedElementValidator() {
        super(new DefaultValidatorConfiguration().setConstraintValidatorRegistry(new LocalConstraintValidators()));
    }

    private static final class LocalConstraintValidators
    extends DefaultConstraintValidators {
        private Map<DefaultConstraintValidators.ValidatorKey, ConstraintValidator<?, ?>> validatorMap;

        private LocalConstraintValidators() {
        }

        @Override
        protected <A extends Annotation, T> Optional<ConstraintValidator<A, T>> findLocalConstraintValidator(@NonNull Class<A> constraintType, @NonNull Class<T> targetType) {
            return this.findConstraintValidatorFromServiceLoader(constraintType, targetType);
        }

        private <A extends Annotation, T> Optional<ConstraintValidator<A, T>> findConstraintValidatorFromServiceLoader(Class<A> constraintType, Class<T> targetType) {
            if (this.validatorMap == null) {
                this.validatorMap = this.initializeValidatorMap();
            }
            return this.validatorMap.entrySet().stream().filter(entry -> {
                DefaultConstraintValidators.ValidatorKey key = (DefaultConstraintValidators.ValidatorKey)entry.getKey();
                Class[] left = new Class[]{constraintType, targetType};
                return TypeArgumentQualifier.areTypesCompatible((Class[])left, Arrays.asList(key.constraintType(), key.targetType()));
            }).findFirst().map(e -> (ConstraintValidator)e.getValue());
        }

        private Map<DefaultConstraintValidators.ValidatorKey, ConstraintValidator<?, ?>> initializeValidatorMap() {
            this.validatorMap = new LinkedHashMap();
            for (ConstraintValidator validator : SoftServiceLoader.load(ConstraintValidator.class).collectAll()) {
                try {
                    Object[] typeArgs = GenericTypeUtils.resolveInterfaceTypeArguments(validator.getClass(), ConstraintValidator.class);
                    if (!ArrayUtils.isNotEmpty((Object[])typeArgs) || typeArgs.length != 2) continue;
                    this.validatorMap.put(new DefaultConstraintValidators.ValidatorKey((Class<?>)typeArgs[0], (Class<?>)typeArgs[1]), validator);
                }
                catch (Exception e) {
                    System.err.println("WARNING: Could not load validator [" + validator.getClass().getName() + "]: " + e.getMessage());
                }
            }
            return this.validatorMap;
        }
    }
}

