/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.messages.Message;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record Option(boolean disabled, boolean selected, @NonNull String value, @NonNull Message label) implements FormElement
{
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @NonNull
    public HtmlTag getTag() {
        return HtmlTag.OPTION;
    }

    public static final class Builder {
        private boolean disabled;
        private String value;
        private boolean selected;
        private Message label;

        @NonNull
        public Builder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @NonNull
        public Builder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        @NonNull
        public Builder value(@NonNull String value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Option build() {
            return new Option(this.disabled, this.selected, this.value, this.label);
        }
    }
}

