/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.messages;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.util.Iterator;
import java.util.Optional;

@Internal
public final class ConstraintViolationUtils {
    private ConstraintViolationUtils() {
    }

    @NonNull
    public static Optional<String> lastNode(@NonNull ConstraintViolation<?> violation) {
        Path propertyPath = violation.getPropertyPath();
        Iterator i = propertyPath.iterator();
        String lastNode = "";
        while (i.hasNext()) {
            Path.Node node = (Path.Node)i.next();
            if (node.getKind() == ElementKind.METHOD || node.getKind() == ElementKind.CONSTRUCTOR || node.getKind() == ElementKind.CONTAINER_ELEMENT) continue;
            lastNode = node.getName();
        }
        return lastNode != null ? Optional.of(lastNode) : Optional.empty();
    }

    @NonNull
    public static Optional<String> constraintCode(@NonNull ConstraintViolation<?> violation) {
        String messageTemplate = violation.getMessageTemplate();
        int index = messageTemplate.lastIndexOf(".message}");
        if (index != -1) {
            String constraintType = messageTemplate.substring(0, index);
            constraintType = constraintType.substring(constraintType.lastIndexOf(".") + ".".length());
            return Optional.of(constraintType);
        }
        return Optional.empty();
    }
}

