/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputStringFormElement;
import io.micronaut.views.fields.messages.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@FunctionalInterface
public interface FormElementRenderer<T extends FormElement> {
    public static final String ATTR_FOR = "for";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_SELECTED = "selected";
    public static final String ATTR_DISABLED = "disabled";
    public static final String ATTR_ID = "id";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_COLS = "cols";
    public static final String ATTR_PLACEHOLDER = "placeholder";
    public static final String ATTR_STEP = "step";
    public static final String ATTR_REQUIRED = "required";
    public static final String ATTR_READ_ONLY = "readonly";
    public static final String ATTR_MAX_LENGTH = "maxlength";
    public static final String ATTR_MIN_LENGTH = "minlength";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CHECKED = "checked";
    public static final String ATTR_TYPE = "type";
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String SLASH = "/";
    public static final String SPACE = " ";

    @NonNull
    public String render(@NonNull T var1, @NonNull Locale var2);

    @NonNull
    default public String render(@NonNull HtmlTag tag, @NonNull List<HtmlAttribute> attributes) {
        return LESS_THAN + tag + SPACE + attributes.stream().map(HtmlAttribute::toString).collect(Collectors.joining(SPACE)) + "/>";
    }

    @NonNull
    default public String render(@NonNull HtmlTag tag, @NonNull List<HtmlAttribute> attributes, @NonNull String content) {
        return this.renderOpenTag(tag, attributes) + content + this.renderCloseTag(tag);
    }

    default public String renderLabel(@Nullable String id, @NonNull Message message, @NonNull MessageSource messageSource, @NonNull Locale locale) {
        return this.render(HtmlTag.LABEL, id != null ? Collections.singletonList(new HtmlAttribute(ATTR_FOR, id)) : Collections.emptyList(), this.content(message, messageSource, locale));
    }

    default public String renderOpenTag(@NonNull HtmlTag tag, @NonNull List<HtmlAttribute> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append(LESS_THAN);
        sb.append((Object)tag);
        if (CollectionUtils.isNotEmpty(attributes)) {
            sb.append(SPACE);
            sb.append(attributes.stream().map(HtmlAttribute::toString).collect(Collectors.joining(SPACE)));
        }
        sb.append(GREATER_THAN);
        return sb.toString();
    }

    default public String renderCloseTag(@NonNull HtmlTag tag) {
        return "</" + tag + GREATER_THAN;
    }

    default public String content(@NonNull Message message, @NonNull MessageSource messageSource, @NonNull Locale locale) {
        if (message.code() != null) {
            return messageSource.getMessage(message.code(), message.defaultMessage(), locale);
        }
        return message.defaultMessage();
    }

    default public HtmlAttribute typeHtmlAttribute(@NonNull InputType type) {
        return new HtmlAttribute(ATTR_TYPE, type.toString());
    }

    @NonNull
    default public List<HtmlAttribute> attributes(@NonNull InputStringFormElement el, @NonNull InputType type) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(11);
        attributes.add(this.typeHtmlAttribute(type));
        attributes.add(new HtmlAttribute(ATTR_NAME, el.name()));
        if (el.value() != null) {
            attributes.add(new HtmlAttribute(ATTR_VALUE, el.value()));
        }
        if (el.id() != null) {
            attributes.add(new HtmlAttribute(ATTR_ID, el.id()));
        }
        if (el.placeholder() != null) {
            attributes.add(new HtmlAttribute(ATTR_PLACEHOLDER, el.placeholder()));
        }
        if (el.pattern() != null) {
            attributes.add(new HtmlAttribute(ATTR_PATTERN, el.pattern()));
        }
        if (el.minLength() != null) {
            attributes.add(new HtmlAttribute(ATTR_MIN_LENGTH, String.valueOf(el.minLength())));
        }
        if (el.maxLength() != null) {
            attributes.add(new HtmlAttribute(ATTR_MAX_LENGTH, String.valueOf(el.maxLength())));
        }
        if (el.size() != null) {
            attributes.add(new HtmlAttribute(ATTR_SIZE, String.valueOf(el.size())));
        }
        if (el.required()) {
            attributes.add(new HtmlAttribute(ATTR_REQUIRED, null));
        }
        if (el.readOnly()) {
            attributes.add(new HtmlAttribute(ATTR_READ_ONLY, null));
        }
        return attributes;
    }
}

