/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.elements.TextareaFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class TextareaFormElementRenderer
implements FormElementRenderer<TextareaFormElement> {
    private final MessageSource messageSource;

    public TextareaFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public String render(TextareaFormElement formElement, Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (formElement.label() != null) {
            sb.append(this.renderLabel(formElement.id(), formElement.label(), this.messageSource, locale));
        }
        sb.append(this.render(HtmlTag.TEXTAREA, this.attributes(formElement), formElement.value()));
        return sb.toString();
    }

    protected List<HtmlAttribute> attributes(TextareaFormElement el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(7);
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.id() != null) {
            attributes.add(new HtmlAttribute("id", el.id()));
        }
        if (el.cols() != null) {
            attributes.add(new HtmlAttribute("cols", String.valueOf(el.cols())));
        }
        if (el.rows() != null) {
            attributes.add(new HtmlAttribute("rows", String.valueOf(el.rows())));
        }
        if (el.placeholder() != null) {
            attributes.add(new HtmlAttribute("placeholder", el.placeholder()));
        }
        if (el.required()) {
            attributes.add(new HtmlAttribute("required", null));
        }
        if (el.readOnly()) {
            attributes.add(new HtmlAttribute("readonly", null));
        }
        return attributes;
    }
}

