/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.TrixEditorFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class TrixEditorFormElementRenderer
implements FormElementRenderer<TrixEditorFormElement> {
    private static final String TAG_TRIX_EDITOR = "trix-editor";
    private final MessageSource messageSource;

    public TrixEditorFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public String render(TrixEditorFormElement formElement, Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (formElement.label() != null) {
            sb.append(this.renderLabel(formElement.id(), formElement.label(), this.messageSource, locale));
        }
        sb.append(this.render(HtmlTag.INPUT, this.inputAttributes(formElement)));
        sb.append(this.render(HtmlTag.TRIX_EDITOR, Collections.singletonList(new HtmlAttribute(HtmlTag.INPUT.toString(), formElement.id())), ""));
        return sb.toString();
    }

    protected List<HtmlAttribute> inputAttributes(TrixEditorFormElement el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(4);
        attributes.add(this.typeHtmlAttribute(InputType.HIDDEN));
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.id() != null) {
            attributes.add(new HtmlAttribute("id", el.id()));
        }
        if (el.value() != null) {
            attributes.add(new HtmlAttribute("value", el.value()));
        }
        return attributes;
    }
}

