/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.repository.CsrfTokenRepository;
import io.micronaut.views.fields.FieldsetConsumer;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.elements.InputHiddenFormElement;
import jakarta.inject.Singleton;
import java.util.List;

@Requires(beans={CsrfTokenRepository.class, CsrfTokenRepository.class})
@Internal
@Singleton
final class CsrfFieldsetConsumer
implements FieldsetConsumer {
    private final CsrfTokenRepository<HttpRequest<?>> csrfTokenRepository;
    private final CsrfConfiguration csrfConfiguration;

    CsrfFieldsetConsumer(CsrfTokenRepository<HttpRequest<?>> csrfTokenRepository, CsrfConfiguration csrfConfiguration) {
        this.csrfTokenRepository = csrfTokenRepository;
        this.csrfConfiguration = csrfConfiguration;
    }

    @Override
    public void accept(@NonNull List<FormElement> formElements) {
        ServerRequestContext.currentRequest().flatMap(arg_0 -> this.csrfTokenRepository.findCsrfToken(arg_0)).ifPresent(t -> formElements.add(this.csrfInputHidden((String)t)));
    }

    @NonNull
    private InputHiddenFormElement csrfInputHidden(@NonNull String csrfToken) {
        return InputHiddenFormElement.builder().name(this.csrfConfiguration.getFieldName()).value(csrfToken).build();
    }
}

