/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.Checkbox;
import io.micronaut.views.fields.elements.InputFormElement;
import io.micronaut.views.fields.messages.Message;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record InputCheckboxFormElement(@NonNull List<Checkbox> checkboxes, @NonNull Message label, @NonNull List<Message> errors) implements InputFormElement
{
    @Override
    @NonNull
    public InputType getType() {
        return InputType.CHECKBOX;
    }

    public boolean hasErrors() {
        return !this.errors().isEmpty();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<Checkbox> checkboxes;
        private Message label;
        private List<Message> errors;

        @NonNull
        public Builder checkboxes(List<Checkbox> checkboxes) {
            this.checkboxes = checkboxes;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public InputCheckboxFormElement build() {
            return new InputCheckboxFormElement(this.checkboxes == null ? Collections.emptyList() : this.checkboxes, this.label, this.errors == null ? Collections.emptyList() : this.errors);
        }
    }
}

