/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.FormElementAttributes;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.elements.InputFormElement;
import io.micronaut.views.fields.messages.Message;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record InputDateTimeLocalFormElement(@NonNull String name, @Nullable String id, boolean required, @Nullable LocalDateTime max, @Nullable LocalDateTime min, @Nullable LocalDateTime value, @Nullable String step, @Nullable Message label, @NonNull List<Message> errors) implements InputFormElement,
GlobalAttributes,
FormElementAttributes
{
    @Override
    @NonNull
    public InputType getType() {
        return InputType.DATE_TIME_LOCAL;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String id;
        private boolean required;
        private LocalDateTime max;
        private LocalDateTime min;
        private LocalDateTime value;
        private String step;
        private List<Message> errors;
        private Message label;

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Builder max(@NonNull LocalDateTime max) {
            this.max = max;
            return this;
        }

        @NonNull
        public Builder min(@NonNull LocalDateTime min) {
            this.min = min;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder step(@NonNull String step) {
            this.step = step;
            return this;
        }

        @NonNull
        public Builder value(@NonNull LocalDateTime value) {
            this.value = value;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public InputDateTimeLocalFormElement build() {
            return new InputDateTimeLocalFormElement(this.name, this.id, this.required, this.max, this.min, this.value, this.step, this.label, this.errors == null ? Collections.emptyList() : this.errors);
        }
    }
}

