/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.elements;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.elements.FormElementAttributes;
import io.micronaut.views.fields.elements.GlobalAttributes;
import io.micronaut.views.fields.elements.Option;
import io.micronaut.views.fields.messages.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Introspected(builder=@Introspected.IntrospectionBuilder(builderClass=Builder.class))
public record SelectFormElement(@NonNull boolean required, @NonNull String name, @Nullable String id, @NonNull List<Option> options, @NonNull Message label, @NonNull List<Message> errors) implements FormElement,
GlobalAttributes,
FormElementAttributes
{
    @Override
    @NonNull
    public HtmlTag getTag() {
        return HtmlTag.SELECT;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean required;
        @NonNull
        private String name;
        @Nullable
        private String id;
        private List<Option> options;
        private Message label;
        private List<Message> errors;

        @NonNull
        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder options(List<Option> options) {
            this.options = options;
            return this;
        }

        @NonNull
        public Builder label(Message label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder errors(@NonNull List<Message> errors) {
            this.errors = errors;
            return this;
        }

        @NonNull
        public SelectFormElement build() {
            return new SelectFormElement(this.required, Objects.requireNonNull(this.name), this.id, this.options == null ? Collections.emptyList() : this.options, this.label, this.errors != null ? this.errors : Collections.emptyList());
        }
    }
}

