/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.formelementresolvers;

import io.micronaut.core.beans.BeanProperty;
import io.micronaut.views.fields.FormElement;
import io.micronaut.views.fields.annotations.InputCheckbox;
import io.micronaut.views.fields.annotations.InputEmail;
import io.micronaut.views.fields.annotations.InputHidden;
import io.micronaut.views.fields.annotations.InputPassword;
import io.micronaut.views.fields.annotations.InputRadio;
import io.micronaut.views.fields.annotations.InputTel;
import io.micronaut.views.fields.annotations.InputUrl;
import io.micronaut.views.fields.annotations.Select;
import io.micronaut.views.fields.annotations.Textarea;
import io.micronaut.views.fields.annotations.TrixEditor;
import io.micronaut.views.fields.elements.InputCheckboxFormElement;
import io.micronaut.views.fields.elements.InputDateFormElement;
import io.micronaut.views.fields.elements.InputDateTimeLocalFormElement;
import io.micronaut.views.fields.elements.InputEmailFormElement;
import io.micronaut.views.fields.elements.InputHiddenFormElement;
import io.micronaut.views.fields.elements.InputNumberFormElement;
import io.micronaut.views.fields.elements.InputPasswordFormElement;
import io.micronaut.views.fields.elements.InputRadioFormElement;
import io.micronaut.views.fields.elements.InputTelFormElement;
import io.micronaut.views.fields.elements.InputTextFormElement;
import io.micronaut.views.fields.elements.InputTimeFormElement;
import io.micronaut.views.fields.elements.InputUrlFormElement;
import io.micronaut.views.fields.elements.SelectFormElement;
import io.micronaut.views.fields.elements.TextareaFormElement;
import io.micronaut.views.fields.elements.TrixEditorFormElement;
import io.micronaut.views.fields.formelementresolvers.FormElementResolver;
import jakarta.inject.Singleton;
import jakarta.validation.constraints.Email;
import java.lang.annotation.Annotation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.Optional;

@Singleton
public class DefaultFormElementResolver
implements FormElementResolver {
    public static final int ORDER = 0;
    private static final String CLASS_IO_MICRONAUT_DATA_ANNOTATION_AUTO_POPULATED = "io.micronaut.data.annotation.AutoPopulated";
    private static final Map<Class<? extends Annotation>, Class<? extends FormElement>> ANNOTATION_MAPPING = Map.ofEntries(Map.entry(InputHidden.class, InputHiddenFormElement.class), Map.entry(InputRadio.class, InputRadioFormElement.class), Map.entry(InputCheckbox.class, InputCheckboxFormElement.class), Map.entry(InputPassword.class, InputPasswordFormElement.class), Map.entry(InputEmail.class, InputEmailFormElement.class), Map.entry(Email.class, InputEmailFormElement.class), Map.entry(InputUrl.class, InputUrlFormElement.class), Map.entry(InputTel.class, InputTelFormElement.class), Map.entry(Select.class, SelectFormElement.class), Map.entry(Textarea.class, TextareaFormElement.class), Map.entry(TrixEditor.class, TrixEditorFormElement.class));

    @Override
    public <B, T> Optional<Class<? extends FormElement>> resolve(BeanProperty<B, T> beanProperty) {
        if (beanProperty.hasStereotype(CLASS_IO_MICRONAUT_DATA_ANNOTATION_AUTO_POPULATED)) {
            return Optional.empty();
        }
        for (Map.Entry<Class<? extends Annotation>, Class<? extends FormElement>> mapping : ANNOTATION_MAPPING.entrySet()) {
            if (!beanProperty.hasAnnotation(mapping.getKey())) continue;
            return Optional.of(mapping.getValue());
        }
        if (beanProperty.getType() == LocalDate.class) {
            return Optional.of(InputDateFormElement.class);
        }
        if (beanProperty.getType() == LocalDateTime.class) {
            return Optional.of(InputDateTimeLocalFormElement.class);
        }
        if (beanProperty.getType() == LocalTime.class) {
            return Optional.of(InputTimeFormElement.class);
        }
        if (Number.class.isAssignableFrom(beanProperty.getType())) {
            return Optional.of(InputNumberFormElement.class);
        }
        if (beanProperty.getType() == Boolean.TYPE) {
            return Optional.of(InputCheckboxFormElement.class);
        }
        if (beanProperty.getType().isEnum()) {
            return Optional.of(SelectFormElement.class);
        }
        if (CharSequence.class.isAssignableFrom(beanProperty.getType())) {
            return Optional.of(InputTextFormElement.class);
        }
        return Optional.empty();
    }

    public int getOrder() {
        return 0;
    }
}

