/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.messages;

import io.micronaut.context.MessageSource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.messages.Message;
import java.util.Locale;
import java.util.Optional;

public class MessageResolver {
    private final MessageSource messageSource;

    public MessageResolver(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @NonNull
    public String getMessageOrDefault(@NonNull Message message, @NonNull Locale locale) {
        return this.messageSource.getMessage(message.code(), message.defaultMessage(), locale, message.variables());
    }

    @NonNull
    public Optional<String> getMessage(@NonNull Message message, @NonNull Locale locale) {
        return this.messageSource.getMessage(message.code(), locale, message.variables());
    }
}

