/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputDateTimeLocalFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class InputDateTimeLocalFormElementRenderer
implements FormElementRenderer<InputDateTimeLocalFormElement> {
    private final MessageSource messageSource;

    public InputDateTimeLocalFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public String render(InputDateTimeLocalFormElement el, Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (el.label() != null) {
            sb.append(this.renderLabel(el.id(), el.label(), this.messageSource, locale));
        }
        sb.append(this.render(HtmlTag.INPUT, this.attributes(el)));
        return sb.toString();
    }

    @NonNull
    protected List<HtmlAttribute> attributes(@NonNull InputDateTimeLocalFormElement el) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(7);
        attributes.add(this.typeHtmlAttribute(InputType.DATE_TIME_LOCAL));
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.value() != null) {
            attributes.add(new HtmlAttribute("value", el.value().toString()));
        }
        if (el.id() != null) {
            attributes.add(new HtmlAttribute("id", el.id()));
        }
        if (el.min() != null) {
            attributes.add(new HtmlAttribute("min", el.min().toString()));
        }
        if (el.max() != null) {
            attributes.add(new HtmlAttribute("max", el.max().toString()));
        }
        if (el.required()) {
            attributes.add(new HtmlAttribute("required", null));
        }
        return attributes;
    }
}

