/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlAttribute;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputRadioFormElement;
import io.micronaut.views.fields.elements.Radio;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class InputRadioFormElementRenderer
implements FormElementRenderer<InputRadioFormElement> {
    private final MessageSource messageSource;

    public InputRadioFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    @NonNull
    public String render(@NonNull InputRadioFormElement el, @NonNull Locale locale) {
        StringBuilder html = new StringBuilder();
        for (Radio radio : el.buttons()) {
            html.append(this.renderOpenTag(HtmlTag.DIV, Collections.emptyList()));
            html.append(this.render(HtmlTag.INPUT, this.attributes(el, radio)));
            if (radio.label() != null) {
                html.append(this.renderLabel(radio.id(), radio.label(), this.messageSource, locale));
            }
            html.append(this.renderCloseTag(HtmlTag.DIV));
        }
        return html.toString();
    }

    protected List<HtmlAttribute> attributes(@NonNull InputRadioFormElement el, @NonNull Radio radio) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(6);
        attributes.add(this.typeHtmlAttribute(InputType.RADIO));
        attributes.add(new HtmlAttribute("name", el.name()));
        if (el.required()) {
            attributes.add(new HtmlAttribute("required", null));
        }
        attributes.addAll(this.attributes(radio));
        return attributes;
    }

    protected List<HtmlAttribute> attributes(@NonNull Radio radio) {
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>(3);
        attributes.add(new HtmlAttribute("value", radio.value()));
        if (radio.id() != null) {
            attributes.add(new HtmlAttribute("id", radio.id()));
        }
        if (radio.checked()) {
            attributes.add(new HtmlAttribute("checked", null));
        }
        return attributes;
    }
}

