/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.fields.render.secondary;

import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.views.fields.HtmlTag;
import io.micronaut.views.fields.InputType;
import io.micronaut.views.fields.elements.InputUrlFormElement;
import io.micronaut.views.fields.render.FormElementRenderer;
import jakarta.inject.Singleton;
import java.util.Locale;

@Internal
@Secondary
@Singleton
public class InputUrlFormElementRenderer
implements FormElementRenderer<InputUrlFormElement> {
    private final MessageSource messageSource;

    public InputUrlFormElementRenderer(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    @NonNull
    public String render(@NonNull InputUrlFormElement el, @NonNull Locale locale) {
        StringBuilder sb = new StringBuilder();
        if (el.label() != null) {
            sb.append(this.renderLabel(el.id(), el.label(), this.messageSource, locale));
        }
        sb.append(this.render(HtmlTag.INPUT, this.attributes(el, InputType.URL)));
        return sb.toString();
    }
}

