/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.freemarker;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.freemarker.FreemarkerViewsRendererConfigurationProperties;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@Requirements(value={@Requires(property="micronaut.views.freemarker.enabled", notEquals="false"), @Requires(classes={Configuration.class})})
@Singleton
public class FreemarkerViewsRenderer<T, R>
implements ViewsRenderer<T, R> {
    protected final ViewsConfiguration viewsConfiguration;
    protected final FreemarkerViewsRendererConfigurationProperties freemarkerMicronautConfiguration;
    protected final String extension;

    @Inject
    public FreemarkerViewsRenderer(ViewsConfiguration viewsConfiguration, FreemarkerViewsRendererConfigurationProperties freemarkerConfiguration) {
        this.viewsConfiguration = viewsConfiguration;
        this.freemarkerMicronautConfiguration = freemarkerConfiguration;
        this.extension = freemarkerConfiguration.getDefaultExtension();
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable T data, @Nullable R request) {
        Template template;
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        try {
            template = this.freemarkerMicronautConfiguration.getTemplate(this.viewLocation(viewName));
        }
        catch (IOException e) {
            throw new ViewRenderingException("Error rendering Freemarker view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
        return writer -> {
            try {
                template.process((Object)ViewUtils.modelOf((Object)data), writer);
            }
            catch (TemplateException e) {
                throw new ViewRenderingException("Error rendering Freemarker view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
            }
        };
    }

    public boolean exists(@NonNull String view) {
        try {
            this.freemarkerMicronautConfiguration.getTemplate(this.viewLocation(view));
        }
        catch (ParseException | MalformedTemplateNameException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private String viewLocation(String name) {
        return ViewUtils.normalizeFile((String)name, (String)this.extension) + "." + this.extension;
    }
}

