/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.views.ViewUtils;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.exceptions.ViewRenderingException;
import io.micronaut.views.handlebars.HandlebarsViewsRendererConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;

@Requirements(value={@Requires(property="micronaut.views.handlebars.enabled", notEquals="false"), @Requires(classes={Handlebars.class})})
@Singleton
public class HandlebarsViewsRenderer<T, R>
implements ViewsRenderer<T, R> {
    protected final ViewsConfiguration viewsConfiguration;
    protected final ResourceLoader resourceLoader;
    protected HandlebarsViewsRendererConfiguration handlebarsViewsRendererConfiguration;
    protected Handlebars handlebars;
    protected String folder;

    @Inject
    public HandlebarsViewsRenderer(ViewsConfiguration viewsConfiguration, ClassPathResourceLoader resourceLoader, HandlebarsViewsRendererConfiguration handlebarsViewsRendererConfiguration, Handlebars handlebars) {
        this.viewsConfiguration = viewsConfiguration;
        this.resourceLoader = resourceLoader;
        this.handlebarsViewsRendererConfiguration = handlebarsViewsRendererConfiguration;
        this.folder = viewsConfiguration.getFolder();
        this.handlebars = handlebars;
    }

    @NonNull
    public Writable render(@NonNull String viewName, @Nullable T data, @Nullable R request) {
        Template template;
        ArgumentUtils.requireNonNull((String)"viewName", (Object)viewName);
        String location = this.viewLocation(viewName);
        try {
            template = this.handlebars.compile(location);
        }
        catch (IOException e) {
            throw new ViewRenderingException("Error rendering Handlebars view [" + viewName + "]: " + e.getMessage(), (Throwable)e);
        }
        return writer -> {
            try {
                template.apply(data, writer);
            }
            catch (Throwable e) {
                throw new ViewRenderingException("Error rendering Handlebars view [" + viewName + "]: " + e.getMessage(), e);
            }
        };
    }

    public boolean exists(@NonNull String viewName) {
        if (viewName == null) {
            return false;
        }
        String location = this.viewLocation(viewName) + "." + this.extension();
        return this.resourceLoader.getResource(location).isPresent();
    }

    private String viewLocation(String name) {
        return this.folder + ViewUtils.normalizeFile((String)name, (String)this.extension());
    }

    private String extension() {
        return this.handlebarsViewsRendererConfiguration.getDefaultExtension();
    }
}

